<?php

namespace AutoForumSyncPro\Entity;

class TargetSite
{
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function getTargetId()
    {
        return isset($this->data['target_id']) ? $this->data['target_id'] : null;
    }

    public function getSiteName()
    {
        return isset($this->data['site_name']) ? $this->data['site_name'] : '';
    }

    public function getBaseUrl()
    {
        return isset($this->data['base_url']) ? $this->data['base_url'] : '';
    }

    public function getSiteType()
    {
        return isset($this->data['site_type']) ? $this->data['site_type'] : 'custom';
    }

    public function isEnabled()
    {
        return (bool) (isset($this->data['enabled']) ? $this->data['enabled'] : false);
    }

    public function getDefaultUserId()
    {
        return isset($this->data['default_user_id']) ? $this->data['default_user_id'] : 0;
    }

    public function getDefaultForumId()
    {
        return isset($this->data['default_forum_id']) ? $this->data['default_forum_id'] : 0;
    }

    public function getDelayBetweenRequests()
    {
        return isset($this->data['delay_between_requests']) ? $this->data['delay_between_requests'] : 1;
    }

    public function getLastRunTime()
    {
        return isset($this->data['last_run_time']) ? $this->data['last_run_time'] : null;
    }

    public function getCustomUrls()
    {
        return isset($this->data['custom_urls']) ? $this->data['custom_urls'] : '';
    }

    public function setEnabled($enabled)
    {
        $this->data['enabled'] = (bool) $enabled;
    }

    public function setLastRunTime($time)
    {
        $this->data['last_run_time'] = $time;
    }

    public function toArray()
    {
        return $this->data;
    }
}
