<?php

namespace AutoForumSyncPro\Admin\Controller;

use XF\Admin\Controller\AbstractController;
use XF\Mvc\ParameterBag;

class Targets extends AbstractController
{
    /**
     * Hedef siteler listesi
     */
    public function actionIndex()
    {
        $targets = $this->getTargets();
        
        $viewParams = array(
            'targets' => $targets
        );

        return $this->view('AutoForumSyncPro:Targets', 'auto_forum_sync_targets', $viewParams);
    }

    /**
     * Hedef site ekle/düzenle
     */
    public function actionEdit(ParameterBag $params)
    {
        $target = $this->assertTargetExists($params->target_id);
        
        if ($this->isPost()) {
            $this->targetSaveProcess($target)->run();
            return $this->redirect($this->buildLink('auto-forum-sync/targets'));
        }

        $viewParams = array(
            'target' => $target,
            'users' => $this->getUserOptions(),
            'forums' => $this->getForumOptions(),
        );

        return $this->view('AutoForumSyncPro:Targets', 'auto_forum_sync_target_edit', $viewParams);
    }

    /**
     * Hedef site kaydet
     */
    protected function targetSaveProcess($target)
    {
        $form = $this->formAction();

        $input = $this->filter(array(
            'site_name' => 'str',
            'base_url' => 'str',
            'site_type' => 'str',
            'enabled' => 'bool',
            'default_user_id' => 'uint',
            'default_forum_id' => 'uint',
            'delay_between_requests' => 'uint',
            'custom_urls' => 'str',
        ));

        $form->basicEntitySave($target, $input);

        return $form;
    }

    /**
     * Hedef site sil
     */
    public function actionDelete(ParameterBag $params)
    {
        $target = $this->assertTargetExists($params->target_id);
        
        if ($this->isPost()) {
            $target->delete();
            return $this->redirect($this->buildLink('auto-forum-sync/targets'));
        }

        $viewParams = array(
            'target' => $target
        );

        return $this->view('AutoForumSyncPro:Targets', 'auto_forum_sync_target_delete', $viewParams);
    }

    /**
     * Hedef site test et
     */
    public function actionTest(ParameterBag $params)
    {
        $target = $this->assertTargetExists($params->target_id);
        
        $contentFetcher = new \AutoForumSyncPro\Service\ContentFetcher();
        $isConnected = $contentFetcher->testConnection($target->base_url);

        if ($isConnected) {
            return $this->message('Bağlantı başarılı!');
        } else {
            return $this->error('Bağlantı başarısız!');
        }
    }

    /**
     * Hedef siteleri al
     */
    protected function getTargets()
    {
        return \XF::db()->fetchAll("SELECT * FROM xf_auto_forum_sync_targets ORDER BY created_date DESC");
    }

    /**
     * Hedef site var mı kontrol et
     */
    protected function assertTargetExists($id)
    {
        if ($id) {
            $target = \XF::db()->fetchRow("SELECT * FROM xf_auto_forum_sync_targets WHERE target_id = ?", $id);
            if (!$target) {
                throw $this->exception($this->notFound('Hedef site bulunamadı.'));
            }
            return $target;
        }
        return null;
    }

    /**
     * Kullanıcı seçenekleri
     */
    protected function getUserOptions()
    {
        $users = $this->em()->find('XF:User', array())->fetch();
        
        $options = array();
        foreach ($users as $user) {
            $options[$user->user_id] = $user->username;
        }
        
        return $options;
    }

    /**
     * Forum seçenekleri
     */
    protected function getForumOptions()
    {
        $forums = $this->em()->find('XF:Forum', array())->fetch();
        
        $options = array();
        foreach ($forums as $forum) {
            $options[$forum->node_id] = $forum->title;
        }
        
        return $options;
    }
}
