<?php

namespace AutoForumSyncPro\Admin\Controller;

use XF\Admin\Controller\AbstractController;
use XF\Mvc\ParameterBag;

class Settings extends AbstractController
{
    /**
     * Ana ayarlar sayfası
     */
    public function actionIndex()
    {
        $options = \XF::options();
        
        $viewParams = array(
            'autoForumSyncEnabled' => $options->autoForumSyncEnabled,
            'autoForumSyncDefaultUser' => $options->autoForumSyncDefaultUser,
            'autoForumSyncDefaultForum' => $options->autoForumSyncDefaultForum,
            'autoForumSyncMaxPostsPerRun' => $options->autoForumSyncMaxPostsPerRun,
            'autoForumSyncDelayBetweenPosts' => $options->autoForumSyncDelayBetweenPosts,
        );

        return $this->view('AutoForumSyncPro:Settings', 'auto_forum_sync_settings', $viewParams);
    }

    /**
     * Ayarları kaydet
     */
    public function actionSave()
    {
        $this->assertPostOnly();

        $input = $this->filter(array(
            'autoForumSyncEnabled' => 'bool',
            'autoForumSyncDefaultUser' => 'uint',
            'autoForumSyncDefaultForum' => 'uint',
            'autoForumSyncMaxPostsPerRun' => 'uint',
            'autoForumSyncDelayBetweenPosts' => 'uint',
        ));

        // Kullanıcı kontrolü
        if ($input['autoForumSyncDefaultUser'] > 0) {
            $user = $this->em()->find('XF:User', $input['autoForumSyncDefaultUser']);
            if (!$user) {
                throw $this->exception($this->error('Geçersiz kullanıcı seçildi.'));
            }
        }

        // Forum kontrolü
        if ($input['autoForumSyncDefaultForum'] > 0) {
            $forum = $this->em()->find('XF:Forum', $input['autoForumSyncDefaultForum']);
            if (!$forum) {
                throw $this->exception($this->error('Geçersiz forum seçildi.'));
            }
        }

        // Ayarları kaydet
        $this->repository('XF:Option')->updateOptions($input);

        return $this->redirect($this->buildLink('auto-forum-sync/settings'));
    }

    /**
     * Test bağlantısı
     */
    public function actionTestConnection()
    {
        $this->assertPostOnly();

        $url = $this->filter('url', 'str');
        
        if (empty($url)) {
            return $this->error('URL boş olamaz.');
        }

        $contentFetcher = new \AutoForumSyncPro\Service\ContentFetcher();
        $isConnected = $contentFetcher->testConnection($url);

        if ($isConnected) {
            return $this->message('Bağlantı başarılı!');
        } else {
            return $this->error('Bağlantı başarısız!');
        }
    }

    /**
     * Logları temizle
     */
    public function actionCleanLogs()
    {
        $this->assertPostOnly();

        $days = $this->filter('days', 'uint');
        if ($days < 1) {
            $days = 30;
        }

        $logger = new \AutoForumSyncPro\Service\Logger();
        $logger->cleanLogs($days);

        return $this->message('Loglar temizlendi.');
    }

    /**
     * Manuel senkronizasyon
     */
    public function actionManualSync()
    {
        $this->assertPostOnly();

        $targetId = $this->filter('target_id', 'uint');
        
        if ($targetId) {
            $cron = new \AutoForumSyncPro\Cron\ContentSync();
            $cron->runManual($targetId);
            
            return $this->message('Manuel senkronizasyon başlatıldı.');
        } else {
            return $this->error('Hedef site seçilmedi.');
        }
    }
}
