# AutoForumSync Pro - XenForo Eklentisi

## 🚀 Özellikler

AutoForumSync Pro, XenForo forumları için gelişmiş bir otomatik içerik çekme ve yayınlama eklentisidir. Bu eklenti ile başka forumlardan içerik çekip kendi forumunuzda otomatik olarak yayınlayabilirsiniz.

### ✨ Ana Özellikler

- **Çoklu Forum Desteği**: XenForo, VBulletin, PhpBB ve özel siteler
- **Akıllı Spam Filtreleme**: Kara liste, beyaz liste ve regex filtreleme
- **Anahtar Kelime Değiştirme**: Otomatik kelime ve URL değiştirme
- **Cron Job Desteği**: Otomatik zamanlanmış çalışma
- **Gelişmiş Loglama**: Detaylı log kayıtları ve hata yönetimi
- **Yönetim Paneli**: Kolay kullanım
- **Rate Limiting**: Sunucu yükünü azaltma
- **Duplicate Kontrolü**: Aynı içeriğin tekrar yayınlanmasını engelleme

## 📋 Gereksinimler

- **XenForo**: 2.2.0+
- **PHP**: 5.6.0+ (cPanel uyumlu)
- **MySQL**: 5.6+ / MariaDB 10.1+
- **GuzzleHttp**: 5.0+ / 6.0+
- **Symfony DomCrawler**: 2.0+ / 3.0+ / 4.0+

## 🔧 Kurulum

### 1. Eklenti Dosyalarını Yükle

```bash
# Eklenti dosyalarını XenForo root dizinine kopyalayın
cp -r AutoForumSyncPro /path/to/xenforo/src/addons/AutoForumSyncPro
```

### 2. Composer Bağımlılıklarını Yükle

```bash
cd /path/to/xenforo

# PHP 5.6 için (cPanel uyumlu)
composer require guzzlehttp/guzzle:^5.0 symfony/dom-crawler:^2.0

# PHP 7.0+ için
composer require guzzlehttp/guzzle:^6.0 symfony/dom-crawler:^3.0

# PHP 8.0+ için
composer require guzzlehttp/guzzle:^7.0 symfony/dom-crawler:^5.0
```

### 3. Veritabanı Tablolarını Oluştur

```sql
-- Hedef siteler tablosu
CREATE TABLE `xf_auto_forum_sync_targets` (
  `target_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_name` varchar(255) NOT NULL,
  `base_url` varchar(500) NOT NULL,
  `site_type` enum('xenforo','vbulletin','phpbb','custom') NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `default_user_id` int(10) unsigned NOT NULL,
  `default_forum_id` int(10) unsigned NOT NULL,
  `delay_between_requests` int(10) unsigned NOT NULL DEFAULT '1',
  `last_run_time` int(10) unsigned DEFAULT NULL,
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- İçerik logları tablosu
CREATE TABLE `xf_auto_forum_sync_content` (
  `content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` varchar(255) NOT NULL,
  `source_url` varchar(500) NOT NULL,
  `thread_id` int(10) unsigned DEFAULT NULL,
  `post_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `status` enum('published','pending','failed') NOT NULL DEFAULT 'published',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`content_id`),
  UNIQUE KEY `unique_id` (`unique_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Spam filtreleri tablosu
CREATE TABLE `xf_auto_forum_sync_blacklist` (
  `blacklist_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `word` varchar(255) NOT NULL,
  `type` enum('word','regex') NOT NULL DEFAULT 'word',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`blacklist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Beyaz liste tablosu
CREATE TABLE `xf_auto_forum_sync_whitelist` (
  `whitelist_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `word` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`whitelist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Anahtar kelime değiştirme tablosu
CREATE TABLE `xf_auto_forum_sync_replacements` (
  `replacement_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `search_text` varchar(500) NOT NULL,
  `replace_text` varchar(500) NOT NULL,
  `type` enum('simple','regex','url') NOT NULL DEFAULT 'simple',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`replacement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- HTML filtreleri tablosu
CREATE TABLE `xf_auto_forum_sync_html_filters` (
  `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `element` varchar(100) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Bekleyen içerikler tablosu
CREATE TABLE `xf_auto_forum_sync_pending` (
  `pending_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` varchar(255) NOT NULL,
  `source_url` varchar(500) NOT NULL,
  `title` varchar(500) NOT NULL,
  `content` longtext NOT NULL,
  `tags` text,
  `user_id` int(10) unsigned NOT NULL,
  `forum_id` int(10) unsigned NOT NULL,
  `status` enum('pending_approval','approved','rejected') NOT NULL DEFAULT 'pending_approval',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`pending_id`),
  UNIQUE KEY `unique_id` (`unique_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Zamanlanmış çalışmalar tablosu
CREATE TABLE `xf_auto_forum_sync_schedules` (
  `schedule_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `target_id` int(10) unsigned NOT NULL,
  `interval_minutes` int(10) unsigned NOT NULL,
  `next_run` int(10) unsigned NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`schedule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Log tablosu
CREATE TABLE `xf_auto_forum_sync_logs` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` varchar(50) NOT NULL,
  `level` enum('debug','info','warning','error') NOT NULL,
  `message` text NOT NULL,
  `context` text,
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
```

### 4. XenForo Admin Panelinden Eklentiyi Etkinleştir

1. **Admin Panel**'e giriş yapın
2. **Eklentiler** → **Eklenti Yükle**'ye gidin
3. **Dosya Seç** butonuna tıklayın
4. `install/addon-AutoForumSyncPro.xml` dosyasını seçin
5. **Eklenti Yükle** butonuna tıklayın
6. Eklentiyi **Etkinleştir**

## ⚙️ Yapılandırma

### 1. Temel Ayarlar

Admin Panel → Eklentiler → AutoForumSync Pro → Ayarlar

- **Eklentiyi Etkinleştir**: Eklentiyi aktif/pasif yap
- **Varsayılan Kullanıcı**: Otomatik yayınlanan içerikler için kullanıcı
- **Varsayılan Forum**: İçeriklerin yayınlanacağı forum
- **Maksimum Post Sayısı**: Her çalışmada maksimum kaç post çekilsin
- **Gecikme Süresi**: Postlar arası bekleme süresi (saniye)

### 2. Hedef Site Ekleme

Admin Panel → Eklentiler → AutoForumSync Pro → Hedef Siteler

1. **Yeni Hedef Site** butonuna tıkla
2. Site bilgilerini doldur:
   - **Site Adı**: Tanımlayıcı isim
   - **Base URL**: Hedef sitenin ana URL'i
   - **Site Tipi**: XenForo, VBulletin, PhpBB veya Özel
   - **Varsayılan Kullanıcı**: Bu siteden çekilen içerikler için kullanıcı
   - **Varsayılan Forum**: İçeriklerin yayınlanacağı forum
   - **İstekler Arası Gecikme**: Saniye cinsinden bekleme süresi

## 🚀 Kullanım

### Otomatik Çalışma

Eklenti otomatik olarak her 15 dakikada bir çalışır.

### Manuel Çalıştırma

```php
// Belirli bir hedef site için
$cron = new \AutoForumSyncPro\Cron\ContentSync();
$cron->runManual($targetSiteId);

// Tüm hedef siteler için
$cron->run();
```

### Programatik Kullanım

```php
use AutoForumSyncPro\Service\ContentFetcher;
use AutoForumSyncPro\Service\ContentPublisher;

// İçerik çekme
$fetcher = new ContentFetcher();
$fetcher->setTargetSite($targetSite);
$content = $fetcher->fetchFromUrl('https://example.com/thread/123');

// İçerik yayınlama
$publisher = new ContentPublisher();
$result = $publisher->publish($content, [
    'user_id' => 1,
    'forum_id' => 2
]);
```

## 🔒 Güvenlik ve Etik

### ⚠️ Önemli Uyarılar

1. **Telif Hakkı**: Sadece kendi sitenizden veya izin aldığınız sitelerden içerik çekin
2. **Rate Limiting**: Hedef sitenin sunucusunu aşırı yüklemeyin
3. **robots.txt**: Hedef sitenin robots.txt dosyasına uyun
4. **Kullanım Şartları**: Hedef sitenin kullanım şartlarını okuyun

## 📞 Destek

- **GitHub Issues**: Hata bildirimleri ve özellik istekleri
- **Dokümantasyon**: Detaylı kullanım kılavuzu
- **Topluluk**: XenForo topluluğu forumları

## 📄 Lisans

Bu eklenti MIT lisansı altında lisanslanmıştır. Ticari ve kişisel kullanım için ücretsizdir.

---

**Not**: Bu eklentiyi kullanmadan önce hedef sitenin kullanım şartlarını ve telif hakları yasalarını kontrol etmeyi unutmayın.

## 🔧 PHP Sürüm Uyumluluğu

### cPanel Uyumlu Desteği
Eklenti artık cPanel hosting ile uyumlu PHP sürümleri ile çalışır:

- **PHP 5.6**: cPanel uyumlu (minimum)
- **PHP 7.0**: Tam destek
- **PHP 7.4**: Tam destek + performans iyileştirmeleri
- **PHP 8.0+**: Tam destek + en iyi performans

### Sürüm Önerileri
- **Minimum**: PHP 5.6.0 (cPanel uyumlu)
- **Önerilen**: PHP 7.0.0+
- **En İyi**: PHP 7.4.0+

### Composer Bağımlılıkları
```bash
# PHP 5.6 için (cPanel uyumlu)
composer require guzzlehttp/guzzle:^5.0 symfony/dom-crawler:^2.0

# PHP 7.0+ için
composer require guzzlehttp/guzzle:^6.0 symfony/dom-crawler:^3.0

# PHP 8.0+ için  
composer require guzzlehttp/guzzle:^7.0 symfony/dom-crawler:^5.0
```

### cPanel Kurulum
Detaylı cPanel kurulum kılavuzu için `CPANEL_INSTALL.md` dosyasını inceleyin.
