# AutoForumSync Pro - cPanel Kurulum Kılavuzu

## 🚀 cPanel Uyumlu Kurulum

Bu kılavuz, cPanel hosting üzerinde AutoForumSync Pro eklentisini kurmak için hazırlanmıştır.

## 📋 cPanel Gereksinimleri

### Minimum Gereksinimler
- **PHP**: 5.6.0+ (cPanel'de genellikle mevcut)
- **XenForo**: 2.2.0+
- **MySQL**: 5.6+ / MariaDB 10.1+
- **Bellek**: En az 128MB RAM
- **Disk**: En az 50MB boş alan

### Önerilen Gereksinimler
- **PHP**: 7.0+ (cPanel'de seçilebilir)
- **Bellek**: 256MB RAM
- **Disk**: 100MB boş alan

## 🔧 Adım Adım Kurulum

### 1. cPanel'de PHP Sürümünü Kontrol Edin

1. **cPanel**'e giriş yapın
2. **Software** → **Select PHP Version**'a gidin
3. PHP sürümünüzü kontrol edin (5.6+ olmalı)
4. Gerekirse daha yeni bir sürüm seçin

### 2. Eklenti Dosyalarını Yükleyin

#### Yöntem 1: cPanel File Manager ile
1. **cPanel** → **File Manager**'a gidin
2. XenForo root dizinine gidin (genellikle `public_html`)
3. `src/addons/` klasörüne gidin
4. **Upload** butonuna tıklayın
5. Eklenti dosyalarını yükleyin

#### Yöntem 2: FTP ile
```bash
# FTP ile bağlanın
ftp your-domain.com

# XenForo dizinine gidin
cd public_html/src/addons/

# Eklenti dosyalarını yükleyin
put -r AutoForumSyncPro/
```

### 3. Composer Bağımlılıklarını Yükleyin

#### cPanel Terminal ile
1. **cPanel** → **Terminal**'e gidin
2. XenForo root dizinine gidin:
```bash
cd public_html
```

3. Composer bağımlılıklarını yükleyin:
```bash
# PHP 5.6 için
composer require guzzlehttp/guzzle:^5.0 symfony/dom-crawler:^2.0

# PHP 7.0+ için
composer require guzzlehttp/guzzle:^6.0 symfony/dom-crawler:^3.0
```

#### Manuel Yükleme (Composer yoksa)
1. **cPanel** → **File Manager**'a gidin
2. `vendor/` klasörünü oluşturun
3. Gerekli kütüphaneleri manuel olarak yükleyin:
   - GuzzleHttp
   - Symfony DomCrawler

### 4. Veritabanı Tablolarını Oluşturun

#### cPanel phpMyAdmin ile
1. **cPanel** → **phpMyAdmin**'e gidin
2. XenForo veritabanınızı seçin
3. **SQL** sekmesine gidin
4. Aşağıdaki SQL komutlarını çalıştırın:

```sql
-- Hedef siteler tablosu
CREATE TABLE `xf_auto_forum_sync_targets` (
  `target_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_name` varchar(255) NOT NULL,
  `base_url` varchar(500) NOT NULL,
  `site_type` enum('xenforo','vbulletin','phpbb','custom') NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `default_user_id` int(10) unsigned NOT NULL,
  `default_forum_id` int(10) unsigned NOT NULL,
  `delay_between_requests` int(10) unsigned NOT NULL DEFAULT '1',
  `last_run_time` int(10) unsigned DEFAULT NULL,
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- İçerik logları tablosu
CREATE TABLE `xf_auto_forum_sync_content` (
  `content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` varchar(255) NOT NULL,
  `source_url` varchar(500) NOT NULL,
  `thread_id` int(10) unsigned DEFAULT NULL,
  `post_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `status` enum('published','pending','failed') NOT NULL DEFAULT 'published',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`content_id`),
  UNIQUE KEY `unique_id` (`unique_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Spam filtreleri tablosu
CREATE TABLE `xf_auto_forum_sync_blacklist` (
  `blacklist_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `word` varchar(255) NOT NULL,
  `type` enum('word','regex') NOT NULL DEFAULT 'word',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`blacklist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Beyaz liste tablosu
CREATE TABLE `xf_auto_forum_sync_whitelist` (
  `whitelist_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `word` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`whitelist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Anahtar kelime değiştirme tablosu
CREATE TABLE `xf_auto_forum_sync_replacements` (
  `replacement_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `search_text` varchar(500) NOT NULL,
  `replace_text` varchar(500) NOT NULL,
  `type` enum('simple','regex','url') NOT NULL DEFAULT 'simple',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`replacement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- HTML filtreleri tablosu
CREATE TABLE `xf_auto_forum_sync_html_filters` (
  `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `element` varchar(100) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Bekleyen içerikler tablosu
CREATE TABLE `xf_auto_forum_sync_pending` (
  `pending_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` varchar(255) NOT NULL,
  `source_url` varchar(500) NOT NULL,
  `title` varchar(500) NOT NULL,
  `content` longtext NOT NULL,
  `tags` text,
  `user_id` int(10) unsigned NOT NULL,
  `forum_id` int(10) unsigned NOT NULL,
  `status` enum('pending_approval','approved','rejected') NOT NULL DEFAULT 'pending_approval',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`pending_id`),
  UNIQUE KEY `unique_id` (`unique_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Zamanlanmış çalışmalar tablosu
CREATE TABLE `xf_auto_forum_sync_schedules` (
  `schedule_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `target_id` int(10) unsigned NOT NULL,
  `interval_minutes` int(10) unsigned NOT NULL,
  `next_run` int(10) unsigned NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`schedule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Log tablosu
CREATE TABLE `xf_auto_forum_sync_logs` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` varchar(50) NOT NULL,
  `level` enum('debug','info','warning','error') NOT NULL,
  `message` text NOT NULL,
  `context` text,
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
```

### 5. Varsayılan Verileri Ekleyin

```sql
-- Varsayılan spam filtreleri
INSERT INTO `xf_auto_forum_sync_blacklist` (`word`, `type`, `enabled`, `created_date`) VALUES
('viagra', 'word', 1, UNIX_TIMESTAMP()),
('casino', 'word', 1, UNIX_TIMESTAMP()),
('porn', 'word', 1, UNIX_TIMESTAMP()),
('spam', 'word', 1, UNIX_TIMESTAMP()),
('pills', 'word', 1, UNIX_TIMESTAMP());

-- Varsayılan HTML filtreleri
INSERT INTO `xf_auto_forum_sync_html_filters` (`element`, `enabled`, `created_date`) VALUES
('script', 1, UNIX_TIMESTAMP()),
('style', 1, UNIX_TIMESTAMP()),
('iframe', 1, UNIX_TIMESTAMP()),
('object', 1, UNIX_TIMESTAMP()),
('embed', 1, UNIX_TIMESTAMP());

-- Varsayılan anahtar kelime değiştirmeleri
INSERT INTO `xf_auto_forum_sync_replacements` (`search_text`, `replace_text`, `type`, `enabled`, `created_date`) VALUES
('eski-site.com', 'yeni-site.com', 'url', 1, UNIX_TIMESTAMP()),
('Eski Site', 'Yeni Site', 'simple', 1, UNIX_TIMESTAMP());
```

### 6. XenForo Admin Panelinden Eklentiyi Etkinleştirin

1. **XenForo Admin Panel**'e giriş yapın
2. **Eklentiler** → **Eklenti Yükle**'ye gidin
3. **Dosya Seç** butonuna tıklayın
4. `install/addon-AutoForumSyncPro.xml` dosyasını seçin
5. **Eklenti Yükle** butonuna tıklayın
6. Eklentiyi **Etkinleştir**

### 7. İzinleri Ayarlayın

1. **cPanel** → **File Manager**'a gidin
2. Eklenti dosyalarının izinlerini kontrol edin:
   - Klasörler: 755
   - PHP dosyaları: 644
   - XML dosyaları: 644

### 8. Cron Job Ayarlayın

#### cPanel Cron Jobs ile
1. **cPanel** → **Cron Jobs**'a gidin
2. Yeni cron job ekleyin:
   - **Minute**: */15
   - **Hour**: *
   - **Day**: *
   - **Month**: *
   - **Weekday**: *
   - **Command**: `/usr/bin/php /home/username/public_html/cmd.php xf:run-cron`

#### Alternatif: cPanel Cron Jobs
```bash
# Her 15 dakikada bir
*/15 * * * * /usr/bin/php /home/username/public_html/cmd.php xf:run-cron

# Her saatte bir
0 * * * * /usr/bin/php /home/username/public_html/cmd.php xf:run-cron
```

## ⚙️ cPanel Özel Ayarları

### 1. PHP Ayarları
1. **cPanel** → **Select PHP Version**'a gidin
2. **Extensions** sekmesine gidin
3. Gerekli uzantıları etkinleştirin:
   - `curl`
   - `json`
   - `mbstring`
   - `xml`
   - `dom`

### 2. Bellek ve Zaman Aşımı Ayarları
1. **cPanel** → **Select PHP Version** → **Options**'a gidin
2. Ayarları güncelleyin:
   - `memory_limit`: 256M
   - `max_execution_time`: 300
   - `max_input_time`: 300

### 3. .htaccess Ayarları
XenForo root dizininde `.htaccess` dosyasına ekleyin:
```apache
# AutoForumSync Pro için
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteRule ^(.*)$ index.php [QSA,L]
</IfModule>
```

## 🔍 Sorun Giderme

### Yaygın cPanel Sorunları

#### 1. Composer Bulunamıyor
```bash
# cPanel Terminal'de
curl -sS https://getcomposer.org/installer | php
mv composer.phar /usr/local/bin/composer
```

#### 2. İzin Hatası
```bash
# Dosya izinlerini düzeltin
chmod -R 755 /home/username/public_html/src/addons/AutoForumSyncPro/
chmod 644 /home/username/public_html/src/addons/AutoForumSyncPro/*.php
```

#### 3. Bellek Hatası
```bash
# .htaccess'e ekleyin
php_value memory_limit 256M
php_value max_execution_time 300
```

#### 4. Cron Job Çalışmıyor
```bash
# Manuel test
/usr/bin/php /home/username/public_html/cmd.php xf:run-cron
```

### Debug Modu

```php
// cPanel File Manager'da src/Service/Logger.php dosyasını düzenleyin
public function __construct()
{
    $this->logLevel = 'debug'; // Debug modunu etkinleştir
    $this->logToDatabase = true;
    $this->logToFile = true;
}
```

## 📞 cPanel Destek

- **cPanel Dokümantasyonu**: https://docs.cpanel.net/
- **Hosting Sağlayıcı Desteği**: Hosting sağlayıcınızla iletişime geçin
- **XenForo Topluluğu**: XenForo forumlarında yardım alın

## ✅ Kurulum Kontrol Listesi

- [ ] PHP sürümü 5.6+ (cPanel'de kontrol edildi)
- [ ] Eklenti dosyaları yüklendi
- [ ] Composer bağımlılıkları yüklendi
- [ ] Veritabanı tabloları oluşturuldu
- [ ] Varsayılan veriler eklendi
- [ ] XenForo'da eklenti etkinleştirildi
- [ ] Dosya izinleri ayarlandı
- [ ] Cron job ayarlandı
- [ ] Test bağlantısı yapıldı

---

**Not**: Bu kılavuz cPanel hosting için özel olarak hazırlanmıştır. Farklı hosting sağlayıcıları için ek ayarlar gerekebilir.
