<?php

namespace XenSoluce\SEOOptimization\XFRM\Sitemap;

class ResourceItem extends XFCP_ResourceItem
{
	public function isIncluded($record)
	{
        if (!is_array($record->xs_seo) || !isset($record->xs_seo['meta_robots'])) {
            return parent::isIncluded($record);
        }

		if(!empty($record->xs_seo) AND in_array($record->xs_seo['meta_robots'], ['noindex,follow', 'noindex,nofollow']))
		{
			return false;
		}

		return parent::isIncluded($record);
	}
}