<?php

namespace XenSoluce\SEOOptimization\XFMG\Pub\Controller;

use XF\Mvc\ParameterBag;

class Album extends XFCP_Album
{
    public function actionSeo(ParameterBag $params)
    {
    	$album = $this->assertViewableAlbum($params->album_id);
        $seo = $this->plugin('XenSoluce\SEOOptimization:SEO');

        return $seo->actionSeo($album, 'media/albums');
    }

    protected function setupAlbumEdit(\XFMG\Entity\Album $album)
    {
    	$seo = $this->plugin('XenSoluce\SEOOptimization:SEO');
        $seo->actionChangeTitle($album);

    	return parent::setupAlbumEdit($album);
    }
}