<?php

namespace XenSoluce\SEOOptimization\XF\Sitemap;

class Thread extends XFCP_Thread
{
	public function isIncluded($record)
	{
        if (!is_array($record->xs_seo) || !isset($record->xs_seo['meta_robots'])) {
            return parent::isIncluded($record);
        }


		if(!empty($record->xs_seo) && in_array($record->xs_seo['meta_robots'], ['noindex,follow', 'noindex,nofollow']))
		{
			return false;
		}

        if(
            !is_null($record->Prefix)
            && isset($record->Prefix->xs_seo_meta_robots)
            && in_array($record->Prefix->xs_seo_meta_robots, ['noindex,follow', 'noindex,nofollow'])
            && (empty($record->xs_seo) || $record->xs_seo['meta_robots'] === '')
        ) {
            return false;
        }


		return parent::isIncluded($record);
	}
}