<?php

namespace XenSoluce\SEOOptimization\XF\Repository;

use XF\Mvc\Entity\Repository;

class Thread extends XFCP_Thread
{
    public function changeThreadTitle($title)
    {
        if(\XF::options()->xs_seo_thread_titles_lowercase)
        {
            if(\XF::options()->xs_seo_thread_titles_lowercase == 'all')
            {
                $title = utf8_strtolower($title);
            }
            elseif(\XF::options()->xs_seo_thread_titles_lowercase == 'first')
            {
                $title = utf8_ucfirst(utf8_strtolower($title));
            }
            elseif (\XF::options()->xs_seo_thread_titles_lowercase == 'first_letter')
            {
                $titleToArray = explode(' ', $title);
                $titleOuput = [];
                foreach($titleToArray as $value)
                {
                    $titleOuput[] = utf8_ucfirst($value);
                }

                $title = implode(' ', $titleOuput );
            }
        }

        return $title;
    }
}