<?php

namespace XenSoluce\SEOOptimization\XF\Pub\Controller;

use XF\Mvc\ParameterBag;

class Post extends XFCP_Post
{
    protected function setupFirstPostThreadEdit(\XF\Entity\Thread $thread, &$threadChanges)
    {
        $threadEditor = parent::setupFirstPostThreadEdit($thread, $threadChanges);

        $threadEditor->setTitle(\XF::repository('XF:Thread')->changeThreadTitle($threadEditor->getThread()->title));

        if(\XF::visitor()->canEditSeoOwnEntity($thread, $error))
        {
            $input['xs_seo'] = $this->filter('xs_seo', 'array-str');
            $threadEditor->getThread()->bulkSet($input);
        }

        return $threadEditor;
    }
}