<?php

namespace XenSoluce\SEOOptimization\XF\Pub\Controller;

use XF\Mvc\ParameterBag;

class Forum extends XFCP_Forum
{
    protected function setupThreadCreate(\XF\Entity\Forum $forum)
    {
        $creator = parent::setupThreadCreate($forum);
        $input = [];
        $input['title'] = \XF::repository('XF:Thread')->changeThreadTitle($creator->getThread()->title);
        $input['xs_seo_title'] = $input['title'];
        $thread = $creator->getThread();
        
        if(\XF::visitor()->canEditSeoOwnEntity($thread, $error))
        {
            $input['xs_seo'] = $this->filter('xs_seo', 'array-str');
        }

        $thread->bulkSet($input);
        
        return $creator;
    }
}