<?php

namespace XenSoluce\SEOOptimization\XF\Entity;

use XF\Mvc\Entity\Structure;
use XF\Mvc\Entity\Entity;
use XF\Entity\Thread;
use XFMG\Entity\MediaItem;
use XFRM\Entity\ResourceItem;

class User extends XFCP_User
{
    /**
     * @param Entity $entity
     * @param null $error
     * @return bool
     */
    public function canEditSeoOwnEntity(Entity $entity, &$error = null)
    {
        if(!$this->user_id)
        {
            return false;
        }
        if($entity instanceof Thread)
        {
            if($this->hasPermission('xs_seo', 'canEditSeoAllThread'))
            {
                return true;
            }
        }
        if($entity instanceof ResourceItem)
        {
            if($this->hasPermission('xs_seo', 'canEditSeoAllResource'))
            {
                return true;
            }
        }
        if($entity instanceof MediaItem)
        {
            if($this->hasPermission('xs_seo', 'canEditSeoAllMedia'))
            {
                return true;
            }
        }
        if($entity->canEdit($error))
        {
            return (
                $this->user_id &&
                $this->hasPermission('xs_seo', 'canEditSeoOwnEntity')
            );
        }

        return false;
    }
}