<?php
namespace XenSoluce\SEOOptimization\SEO;

use XF\Mvc\Entity\Entity;
use XF\Template\Templater;

/**
 * @property \XFRM\Entity\ResourceItem $entity
 * Class ResourceItem
 * @package XenSoluce\SEOOptimization\SEO
 */
class ResourceItem extends AbstractHandler
{
    protected string $nameItemTitle = 'resource';
    protected string $nameItemDescription = 'resource';

    protected function changeOpenGraph($default = '')
    {
        $options = \XF::options();
        $defaultImage = $options->xs_seo_open_graph_settings;
        $defaultResourceImage = $options->xs_seo_open_graph_rm;
        if($defaultResourceImage !== 'default')
        {
            $defaultImage = $defaultResourceImage;
        }

        if($defaultImage == 'url' && !empty($options->xs_seo_open_graph_img))
        {
            return $options->xs_seo_open_graph_img;
        }

        if($defaultImage == 'avatar')
        {
            return $this->getAvatarUrl($default);
        }

        if($defaultImage == 'attachment')
        {
            $update = $this->entity->Description;
            $imageAttachment = $update->Attachments;
            $canViewAttachment = $this->entity->canViewUpdateImages();

            return $this->getAttachment($imageAttachment, $default, $canViewAttachment);
        }

        if($defaultImage == 'resource_icon')
        {
            if($this->entity->getIconUrl())
            {
                return $this->buildLink($this->entity->getIconUrl());
            }
        }

        return $default;
    }

    protected function option(): array
    {
        return [
            'separator' => \XF::options()->xs_seo_resource_separator,
            'metaTitle' => \XF::options()->xs_seo_resource_meta_title,
            'metaDesc' => \XF::options()->xs_seo_resource_meta_desc
        ];
    }

    protected function description(): string
    {
        return $this->entity->Description->message;
    }
}