<?php
namespace XenSoluce\SEOOptimization\SEO;

use XF\Mvc\Entity\Entity;
use XF\Template\Templater;

/**
 * @property \XFMG\Entity\Album $entity
 * Class ResourceItem
 * @package XenSoluce\SEOOptimization\SEO
 */
class Album extends AbstractHandler
{
    protected function changeOpenGraph($default = '')
    {
        $options = \XF::options();

        $defaultImage = $options->xs_seo_open_graph_settings;

        if($defaultImage == 'url' && !empty($options->xs_seo_open_graph_img))
        {
            return $options->xs_seo_open_graph_img;
        }

        if($defaultImage == 'avatar')
        {
            return $this->getAvatarUrl($default);
        }

        if($defaultImage == 'attachment')
        {
            return $this->entity->getThumbnailUrl(true);
        }

        return $default;
    }

    protected function option(): array
    {
        return [
            'separator' => \XF::options()->xs_seo_album_separator,
            'metaTitle' => \XF::options()->xs_seo_album_meta_title,
            'metaDesc' => \XF::options()->xs_seo_album_meta_desc
        ];
    }

    protected function description(): string
    {
        return $this->entity->description;
    }
}