<?php

namespace XenSoluce\SEOOptimization;

use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Manager;
use XF\Mvc\Entity\Structure;

/**
 * Class Listener
 * @package XenSoluce\SEOOptimization
 */
class Listener
{
    /**
     * @param Manager $em
     * @param Structure $structure
     */
    public static function entityStructure(\XF\Mvc\Entity\Manager $em, \XF\Mvc\Entity\Structure &$structure)
    {
        switch($structure->table)
        {
            case 'xf_node':
            case 'xf_thread':
            case 'xf_rm_category':
            case 'xf_rm_resource':
            case 'xf_mg_category':
            case 'xf_mg_album':
            case 'xf_mg_media_item':
            case 'xf_xa_ams_article':
                $structure->columns['xs_seo'] = ['type' => Entity::JSON_ARRAY, 'nullable' => true, 'default' => []];
                $structure->columns['xs_seo_title'] = ['type' => Entity::STR, 'default' => ''];
                break;
            case 'xf_thread_prefix':
            case 'xf_rm_resource_prefix':
                $structure->columns['xs_seo_meta_robots'] = ['type' => Entity::STR, 'default' => ''];
                break;
        }
    }

    /**
     * @param \XF\Container $container
     * @param \XF\Template\Templater $templater
     * @throws \Exception
     */
    public static function templaterSetup(\XF\Container $container, \XF\Template\Templater &$templater)
    {
        /** @var \XenSoluce\SEOOptimization\Template\TemplaterSetup $templaterSetup */
        $class = \XF::extendClass('XenSoluce\SEOOptimization\Template\TemplaterSetup');
        $templaterSetup = new $class();

        $templater->addFunction('change_title', [$templaterSetup, 'fnXsChangeTitle']);
        $templater->addFunction('change_canonical',  [$templaterSetup, 'fnXsChangeCanonical']);
        $templater->addFunction('change_open_graph',  [$templaterSetup, 'fnXsChangeOpenGraph']);
        $templater->addFunction('change_description', [$templaterSetup, 'fnXsChangeDescription']);
        $templater->addFunction('xs_instance_of', [$templaterSetup, 'fnXsInstanceOf']);
    }

    public static function templaterMacroPreRender(\XF\Template\Templater $templater, &$type, &$template, &$name, array &$arguments, array &$globalVars)
    {
        if (!empty($arguments['group']) && $arguments['group']->group_id == 'xs_seo_settings')
        {
            $template = 'xs_seo_option_macros';
           
            $name = 'option_form_block_tabs';
           
            $arguments['headers'] = [
                'generalOptions'      => [
                    'label'           => \XF::phrase('xs_seo_general_options'),
                    'minDisplayOrder' => 0,
                    'maxDisplayOrder' => 500,
                    'active'          => true
                ],
                'defaultOptions'        => [
                	'moreTabs'			=> [
                		"defaultThread" => [
	                		'label'           => \XF::phrase('xs_seo_default_thread_options'),
	                    	'minDisplayOrder' => 0,
	                    	'maxDisplayOrder' => 400
	                	],
	                	"defaultCategory" => [
	                		'label'           => \XF::phrase('xs_seo_default_category_options'),
	                    	'minDisplayOrder' => 100,
	                    	'maxDisplayOrder' => 300
	                	],
                		"defaultResource" => [
	                		'label'           => \XF::phrase('xs_seo_default_resource_options'),
	                    	'minDisplayOrder' => 200,
	                    	'maxDisplayOrder' => 200
	                	],
	                	"defaultMedia" => [
	                		'label'           => \XF::phrase('xs_seo_default_media_options'),
	                    	'minDisplayOrder' => 300,
	                    	'maxDisplayOrder' => 100
	                	],
	                	"defaultAlbum" => [
	                		'label'           => \XF::phrase('xs_seo_default_album_options'),
	                    	'minDisplayOrder' => 400,
	                    	'maxDisplayOrder' => 0
	                	],
                	],
                    'label'           => \XF::phrase('xs_seo_default_options'),
                    'minDisplayOrder' => 500,
                    'maxDisplayOrder' => 1000
                ],
                'robotOptions'     => [
                    'label'           => \XF::phrase('xs_seo_robot_options'),
                    'minDisplayOrder' => 1000,
                    'maxDisplayOrder' => 1500
                ],
                'categoryOptions'     => [
                    'label'           => \XF::phrase('xs_seo_open_graph_options'),
                    'minDisplayOrder' => 1500,
                    'maxDisplayOrder' => 2000
                ],
                'titleOptions'     => [
                    'label'           => \XF::phrase('xs_seo_title_options'),
                    'minDisplayOrder' => 2000,
                    'maxDisplayOrder' => 2500
                ],
                'addonsOptions'        => [
                    'moreTabs'          => [
                        "xenAddonAms" => [
                            'label'           => \XF::phrase('xs_seo_default_ams_options'),
                            'minDisplayOrder' => 0,
                            'maxDisplayOrder' => 400
                        ],
                    ],
                    'label'           => \XF::phrase('xs_seo_implemented_addons'),
                    'minDisplayOrder' => 2500,
                    'maxDisplayOrder' => 4000
            ]];
        }
    }
}