<?php

namespace XenSoluce\SEOOptimization\Job;

use XF\Job\AbstractJob;
use XF\Db\Schema\Alter;
use XF\Db\Schema\Create;

class RebuildTables extends AbstractJob
{
	public function run($maxRunTime)
	{
		$db = $this->app->db();
		$sm = $db->getSchemaManager();
		
		if($sm->tableExists('xf_rm_category'))
        {
        	$sm->alterTable('xf_rm_category', function(Alter $table)
        	{
        		$table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->nullable('');
        	});
        }
		if($sm->tableExists('xf_rm_resource'))
        {
        	$sm->alterTable('xf_rm_resource', function(Alter $table)
        	{
        		$table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->nullable('');
        	});
        }
		if($sm->tableExists('xf_rm_resource_prefix'))
        {
        	$sm->alterTable('xf_rm_resource_prefix', function(Alter $table)
        	{
                $table->addColumn('xs_seo_meta_robots', 'varchar', 150)->nullable(true);
        	});
        }
        if($sm->tableExists('xf_mg_category'))
        {
        	$sm->alterTable('xf_mg_category', function(Alter $table)
        	{
        		$table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->nullable('');
        	});
        }
        if($sm->tableExists('xf_mg_album'))
        {
            $sm->alterTable('xf_mg_album', function(Alter $table)
            {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->nullable('');
            });
        }
        if($sm->tableExists('xf_mg_media_item'))
        {
            $sm->alterTable('xf_mg_media_item', function(Alter $table)
            {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->nullable('');
            });
        }
        if($sm->tableExists('xf_xa_ams_article'))
        {
            $sm->alterTable('xf_xa_ams_article', function(Alter $table)
            {
                $table->addColumn('xs_seo', 'blob')->nullable(true);
                $table->addColumn('xs_seo_title', 'varchar', 150)->nullable('');
            });
        }

        $this->changeRoute();
        return $this->complete();
	}

	public function getStatusMessage()
	{
		return \XF::phrase('xs_seo_tables');
	}

	public function canCancel()
    {
        return false;
    }

    public function canTriggerByChoice()
    {
        return true;
    }

    protected function changeRoute()
    {
        $routes = [
            'resources' => [
                [
                    'context' => 'xfrm',
                    'format' => ':int<resource_id,title>/',
                    'replace' => ':int<resource_id,xs_seo_title>/'
                ],
            ],
            'albums' => [
                [
                    'context' => 'xfmg',
                    'format' => 'albums/:int<album_id,title>/:page',
                    'replace' => 'albums/:int<album_id,xs_seo_title>/:page'
                ],
                [
                    'context' => 'xfmg',
                    'format' => 'album-comments/:int<album_id,title>/',
                    'replace' => 'album-comments/:int<album_id,xs_seo_title>/'
                ],
                [
                    'context' => 'xfmg',
                    'format' => 'album-ratings/:int<album_id,title>/',
                    'replace' => 'album-ratings/:int<album_id,xs_seo_title>/'
                ]
            ],
            'media' => [
                [
                    'context' => 'xfmg',
                    'format' => ':int<media_id,title>/:page',
                    'replace' => ':int<media_id,xs_seo_title>/:page'
                ],
                [
                    'context' => 'xfmg',
                    'format' => 'media-comments/:int<media_id,title>/',
                    'replace' => 'media-comments/:int<media_id,xs_seo_title>/'
                ],
                [
                    'context' => 'xfmg',
                    'format' => 'media-ratings/:int<media_id,title>/',
                    'replace' => 'media-ratings/:int<media_id,xs_seo_title>/'
                ]
            ]
        ];
        foreach ($routes as $prefix => $route)
        {
            foreach ($route as $value)
            {
                $findRoute = $this->app->finder('XF:Route')->where([
                    'route_type' => 'public',
                    'route_prefix' => $prefix,
                    'format' => $value['format'],
                    'context' => $value['context']
                ])->fetchOne();

                if($findRoute)
                {
                    $findRoute->format = $value['replace'];
                    $findRoute->save();
                }
            }
        }
    }
}