<?php

namespace XenSoluce\SEOOptimization\InlineMod;

use XF\Http\Request;
use XF\InlineMod\AbstractAction;
use XF\Mvc\Entity\AbstractCollection;
use XF\Mvc\Entity\Entity;

class NoFollow extends AbstractAction
{
	protected $type = 'thread';

	public function setType($type)
	{
		$this->type = $type;

		return $this;
	}

	public function getTitle()
	{
		return \XF::phrase('xs_seo_meta_robots...');
	}

	protected function canApplyToEntity(Entity $entity, array $options, &$error = null)
	{
		return \XF::visitor()->canEditSeoOwnEntity($entity);
	}

	protected function applyToEntity(Entity $entity, array $options)
	{
		$value = $options['meta_robots'];
		$seo = $entity->xs_seo;
		$seo['meta_robots'] = $value;
		$entity->xs_seo = $seo;
		$entity->save();
	}

	public function getBaseOptions()
	{
		return [
			'meta_robots' => ''
		];
	}

	public function renderForm(AbstractCollection $entities, \XF\Mvc\Controller $controller)
	{
		$viewParams = [
			'entities' => $entities,
			'type' => $this->type,
			'total' => count($entities)
		];

		return $controller->view('XenSoluce:Public:InlineMod\NoFollow', 'xs_seo_inline_mod_meta_robots', $viewParams);
	}

	public function getFormOptions(AbstractCollection $entities, Request $request)
	{
		return [
			'meta_robots' => $request->filter('meta_robots', 'str')
		];
	}
}