<?php

namespace XenSoluce\SEOOptimization\ControllerPlugin;

use XF\ControllerPlugin\AbstractPlugin;
use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Repository;

/**
 * Class SEO
 * @package XenSoluce\SEOOptimization\ControllerPlugin
 */
class SEO extends AbstractPlugin
{
    /**
     * @param Entity $entity
     * @param $link
     * @param null $category
     * @return \XF\Mvc\Reply\AbstractReply|\XF\Mvc\Reply\Redirect|\XF\Mvc\Reply\View
     * @throws \XF\PrintableException
     */
    public function actionSeo(Entity $entity, $link, $category = null)
    {
        if(!\XF::visitor()->canEditSeoOwnEntity($entity, $error))
        {
            return $this->noPermission($error);
        }
        
        if($this->isPost())
        {
            $entity->xs_seo = $this->filter('xs_seo', 'array-str');
            if(empty($entity->xs_seo['save_url']))
            {
                $entity->xs_seo_title = $entity->title;
            }
            else
            {
                $entity->xs_seo_title = $this->filter('xs_seo_title', 'str');
            }

            $entity->save();

            return $this->redirect($this->buildLink($link, $entity));
        }
        else
        {
            $viewParams = [
                'entity' => $entity,
                'action' => $link
            ];

            return $this->view('', 'xs_seo_entity_edit', $viewParams);
        }
    }

    public function actionChangeTitle(Entity $entity, $field = 'title')
    {
        if($entity->getSeoTitleIsNull() || empty($entity->xs_seo['save_url']))
        {
            $input['xs_seo_title'] = $entity->{$field};
            $entity->bulkSet($input);
        }
    }
}