<?php

namespace XenGenTr\XGTOnekTasarimlari\XF\Template;

use XF\Mvc\ParameterBag;
use XF\Mvc\FormAction;
use XF\Pub\Controller\AbstractController;

class Templater extends XFCP_Templater
{

	public function fnPrefix($templater, &$escape, $contentType, $prefixId, $format = 'html', $append = null)
	{
		if (!is_int($prefixId))
		{
			$prefixId = $prefixId->prefix_id;
		}

		if (!$prefixId)
		{
			return '';
		}

		$prefixCache = $this->app->container('prefixes.' . $contentType);
		$prefixClass = $prefixCache[$prefixId] ?? null;

		if (!$prefixClass)
		{
			return '';
		}

		$output = $this->func('prefix_title', [$contentType, $prefixId], false);

		switch ($format)
		{
			case 'html':
				$output = '<span class="' . htmlspecialchars($prefixClass) . '" dir="auto"><span class="_onek_ikon"></span><span class="_onek_metin">'
					. \XF::escapeString($output, 'html') . '</span></span>';
				if ($append === null)
				{
					$append = '<span class="label-append">&nbsp;</span>';
				}
				break;

			case 'plain':
				if ($output instanceof \XF\Phrase)
				{
					$output = $output->render('raw');
				}
				break; // ok as is

			default:
				$output = \XF::escapeString($output, 'html'); // just be safe and escape everything else
		}

		if ($append === null)
		{
			$append = ' - ';
		}

		$escape = false;
		return $output . $append;
	}
}