<?php

namespace XenGenTr\XGTOnekTasarimlari\Listener;

use XF\Container;
use XF\Template\Templater;
use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Manager;
use XF\Mvc\Entity\Structure;
use XF\App;

class Listener
{
	protected static int $_productId = 102;

    public static function setup(Container $container, Templater $templater)
    {
        $repo = \XF::repository('XenGenTr\XGTOnekTasarimlari:OnekTasarim');

        $tasarimlar = $repo->finder('XenGenTr\XGTOnekTasarimlari:OnekTasarim')
            ->order('onek_id')
            ->fetch();

        $templater->addDefaultParam('xgtTasarimlar', $tasarimlar);
    }

    public static function appPubSetup(App $app): void
    {
        $branding = $app->offsetExists('xengen_branding') ? $app->xengen_branding : [];

        if (!in_array(self::$_productId, $branding)) {
            $branding[] = self::$_productId;
        }

        $app->xengen_branding = $branding;
    }
}
