<?php
namespace XenGenTr\XGTOnekTasarimlari\DBTech\eCommerce\Admin\Controller;

use DBTech\eCommerce\Admin\Controller\ProductPrefixController as BaseProductPrefixController;
use XenGenTr\XGTOnekTasarimlari\Repository\OnekTasarim; 
use XF\Entity\AbstractPrefix;
use XF\Mvc\Reply\AbstractReply;
use XF\Mvc\Reply\View;

class ProductPrefixController extends BaseProductPrefixController
{
    /**
     * @param AbstractPrefix $prefix
     *
     * @return AbstractReply
     */
    protected function prefixAddEditResponse(AbstractPrefix $prefix): AbstractReply
    {
        $reply = parent::prefixAddEditResponse($prefix);

        if ($reply instanceof View) {
            $oneks = \XF::app()->repository(OnekTasarim::class)->getAllOnekTasarimlar();

            $displayStyles = $reply->getParam('displayStyles');

            foreach ($oneks as $onek) {
                $prefix_name = 'xgt_onek_tasarim :' . $onek->onek_id;
                array_push($displayStyles, $prefix_name);
            }
            
            $reply->setParam('displayStyles', $displayStyles);
        }

        return $reply;
    }
}
