<?php

namespace XenGenTr\XGTOnekTasarimlari\Admin\Controller;

use XF\Admin\Controller\AbstractController;
use XF\Mvc\ParameterBag;
use XF\Mvc\FormAction;

class OnekTasarim extends AbstractController
{
    public function actionIndex()
    {
        $this->setSectionContext('xgt_onek_tasarim');

        $finder = $this->finder('XenGenTr\XGTOnekTasarimlari:OnekTasarim');
        $tasarimlar = $finder->order('onek_id', 'ASC')->fetch();

        $viewParams = [
            'tasarim' => $tasarimlar
        ];
        return $this->view('XenGenTr\XGTOnekTasarimlari:OnekTasarim\List', 'xgt_onektasarim_list', $viewParams);
    }

    public function actionAdd()
    {
        $this->setSectionContext('xgt_onek_tasarim');

        $onek = $this->em()->create('XenGenTr\XGTOnekTasarimlari:OnekTasarim');
        return $this->onekForm($onek);
    }

    public function actionEdit(ParameterBag $params)
    {
        $this->setSectionContext('xgt_onek_tasarim');

        $onek = $this->assertOnekExists($params->onek_id);
        return $this->onekForm($onek);
    }

    protected function onekForm($onek)
    {
        return $this->view('XenGenTr\XGTOnekTasarimlari:OnekTasarim\Edit', 'xgt_onektasarim_edit', [
            'onek' => $onek
        ]);
    }

	public function actionSave(ParameterBag $params)
	{
	    $this->setSectionContext('xgt_onek_tasarim');
	
	    $this->assertPostOnly();
	
	    $input = $this->filter([
	        'onek_adi' => 'str',
	        'onek_ikonu' => 'str',
	        'onek_renk' => 'str',
	        'onek_metin' => 'str'
	    ]);
	
	    if ($params->onek_id) {
	        $onek = $this->assertOnekExists($params->onek_id);
	    } else {
	        $limit = 20;
	
	        $existingCount = $this->em()->getFinder('XenGenTr\XGTOnekTasarimlari:OnekTasarim')->total();
	
	        if ($existingCount >= $limit) {
	            return $this->error(\XF::phrase('xgt_onek_tasarimlari_ekleme_limiti_asildi'));
	        }
	
	        $onek = $this->em()->create('XenGenTr\XGTOnekTasarimlari:OnekTasarim');
	    }
	
	    if (empty($input['onek_adi']) || empty($input['onek_ikonu']) || empty($input['onek_renk']) || empty($input['onek_metin'])) {
	        return $this->error('Tm alanlar doldurulmaldr!');
	    }
	
	    $onek->bulkSet($input);
	    $onek->save();
	
	    \XF::repository('XF:Style')->updateAllStylesLastModifiedDate();
	
	    return $this->redirect($this->buildLink('xgt-onektasarim'));
	}

    public function actionDelete(ParameterBag $params)
    {
        $this->setSectionContext('xgtOnekTasarim');

        $onek = $this->assertOnekExists($params->onek_id);

        if ($this->isPost()) {
            $onek->delete();
            return $this->redirect($this->buildLink('xgt-onektasarim'));
        }

        return $this->view('XenGenTr\XGTOnekTasarimlari:OnekTasarim\Delete', 'xgt_onektasarim_delete', [
            'onek' => $onek
        ]);
    }

    protected function assertOnekExists($id)
    {
        return $this->assertRecordExists('XenGenTr\XGTOnekTasarimlari:OnekTasarim', $id);
    }

    protected function getOnekRepo()
    {
        return $this->repository('XenGenTr\XGTOnekTasarimlari:OnekTasarim');
    }
}
