<?php
/**
 * Created by PhpStorm.
 * User: Remi
 * Date: 04/08/2019
 * Time: 02:52
 */

namespace XenConcept\UserActivity\XenConcept\ProjectManager\Entity;

class ProjectItem extends XFCP_ProjectItem
{

    public function canViewProjectViewers(&$error = null)
    {
        /** @var \XenConcept\ProjectManager\XF\Entity\User $visitor */
        $visitor = \XF::visitor();

        if (!$visitor->user_id)
        {
            return $visitor->hasProjectCategoryPermission($this->project_category_id,'viewersAllProject');
        }

        if ($visitor->user_id === $this->user_id)
        {
            return $visitor->hasProjectCategoryPermission($this->project_category_id,'viewersOwnProject');
        }
        else
        {
            return $visitor->hasProjectCategoryPermission($this->project_category_id,'viewersAllProject');
        }
    }

    public function canViewProjectReaders(&$error = null)
    {
        /** @var \XenConcept\ProjectManager\XF\Entity\User $visitor */
        $visitor = \XF::visitor();

        if (!$visitor->user_id)
        {
            return $visitor->hasProjectCategoryPermission($this->project_category_id,'readersAllProject');
        }

        if ($visitor->user_id === $this->user_id)
        {
            return $visitor->hasProjectCategoryPermission($this->project_category_id,'readersOwnProject');
        }
        else
        {
            return $visitor->hasProjectCategoryPermission($this->project_category_id,'readersAllProject');
        }
    }

}