<?php

/*************************************************************************
 * User activity  - XenConcept (c) 2017
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\XF\Repository;

class SessionActivity extends XFCP_SessionActivity
{

    // ############# DEFAULT FUNCTIONS #############

    public function updateSessionActivity($userId, $ip, $controller, $action, array $params, $viewState, $robotKey)
    {
        parent::updateSessionActivity($userId, $ip, $controller, $action, $params, $viewState, $robotKey);

        if (empty($robotKey))
        {
            $this->getNodeSessionActivityRepo()->updateNodeSessionActivity($userId, $ip, $controller, $action, $params, $viewState);
        }
    }

    public function pruneExpiredActivityRecords($cutOff = null)
    {
        parent::pruneExpiredActivityRecords($cutOff);
        $this->getNodeSessionActivityRepo()->pruneExpiredNodeActivityRecords($cutOff);
    }

    public function clearUserActivity($userId, $ip)
    {
        parent::clearUserActivity($userId, $ip);

        $this->getNodeSessionActivityRepo()->clearUserNodeActivity($userId, $ip);
    }

    // ############# CUSTOM FUNCTIONS #############

    /**
     * @return \XenConcept\UserActivity\Repository\NodeSessionActivity|\XF\Mvc\Entity\Repository
     */
    protected function getNodeSessionActivityRepo()
    {
        return $this->repository('XenConcept\UserActivity:NodeSessionActivity');
    }
}