<?php

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2017
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\XF\Repository;

use XF\Mvc\Entity\Manager;

class Node extends XFCP_Node
{

    public function mergeNodeListExtras(array $extras, array $childExtras)
    {
        if (!isset($extras['totalViewers']))
        {
            $extras['totalViewers'] = 0;
        }

        $output = parent::mergeNodeListExtras($extras, $childExtras);

        foreach ($childExtras AS $child)
        {
            if (!empty($child['totalViewers']))
            {
                $output['totalViewers'] += $child['totalViewers'];
            }
        }

        return $output;
    }

    public function getXCUANodeCacheData()
    {
        $nodeList = $this->getFullNodeList();
        $nodeTree = $this->createNodeTree($nodeList);

        $finalOutput = [];
        $f = function (array $children) use (&$f, &$finalOutput)
        {
            $childOutput = [];
            foreach ($children AS $id => $child)
            {
                $childOutput[$id] = $f($child->children());
            }

            return $childOutput;
        };

        foreach ($nodeTree AS $id => $subTree)
        {
            $finalOutput[$id] = $f($subTree->children());
        }

        return $finalOutput;
    }

    public function rebuildXCUANodeCache()
    {
        $cache = $this->getXCUANodeCacheData();
        \XF::registry()->set('XCUANode', $cache);
        return $cache;
    }

    /**
     * @return \XenConcept\UserActivity\Repository\NodeSessionActivity|\XF\Mvc\Entity\Repository
     */
    protected function getNodeSessionActivityRepo()
    {
        return $this->repository('XenConcept\UserActivity:NodeSessionActivity');
    }
}