<?php

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2017
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\XF\Pub\Controller;

use XF\Mvc\ParameterBag;

class Thread extends XFCP_Thread
{
    /**
     * @param ParameterBag $params
     * @return bool|\XF\Mvc\Reply\View
     * @throws \XF\Mvc\Reply\Exception
     */
    public function actionShowReaders(ParameterBag $params)
    {
        /** @var \XenConcept\UserActivity\XF\Entity\Thread $thread */
        $thread = $this->assertViewableThread($params->thread_id);

        if (!\XF::options()->xc_user_activity_enable_readers_thread || !$thread->canViewThreadReaders($error))
        {
            return $this->noPermission();
        }

        $threadRepo = $this->getThreadRepo();
        $threadReadersFinder = $threadRepo->findThreadReadersByThreadId($thread->thread_id, $thread->user_id);

        $title = \XF::phrase('xc_user_activity_who_read_this_thread_total_members_x', ['total' => $threadReadersFinder->total()]);

        $viewParams = [
            'title' => $title,
            'threadReaders' => $threadReadersFinder->fetch()
        ];

        return $this->view('XF:Thread\ShowReaders', 'xc_user_activity_show_thread_readers_overlay', $viewParams);
    }


    public function actionShowMembersReplied(ParameterBag $params)
    {
        /** @var \XenConcept\UserActivity\XF\Entity\Thread $thread */
        $thread = $this->assertViewableThread($params->thread_id);

        if (!$thread->canViewThreadReplies($error))
        {
            return false;
        }

        $threadRepo = $this->getThreadRepo();

        $threadRepliesFinder = $threadRepo->findThreadRepliesByThreadId($thread->thread_id, $thread->user_id);
        $threadReplies = $threadRepliesFinder->fetch();

        $title = \XF::phrase('xc_user_activity_user_who_replied_this_thread_total_member_x', ['totalMember' => count($threadReplies)]);

        $viewParams = [

            'title' => $title,
            'threadReplies' => $threadReplies

        ];

        return $this->view('XF:Thread\ShowMembersReplied', 'xc_user_activity_show_replies_overlay', $viewParams);
    }


    /**
     * @return \XenConcept\UserActivity\XF\Repository\Thread
     */
    protected function getThreadRepo()
    {
        return parent::getThreadRepo();
    }

}