<?php

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2019
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\XF\Entity;

use XF\Mvc\Entity\Structure;

/**
 * RELATIONS
 * @property \XF\Entity\ThreadUserPost XCUAThreadUserPost
 */
class User extends XFCP_User
{

    public static function getStructure(Structure $structure)
    {
        $structure = parent::getStructure($structure);

        $structure->relations['XCUAThreadUserPost'] = [
            'entity'     => 'XF:ThreadUserPost',
            'type'       => self::TO_MANY,
            'conditions' => 'user_id',
            'key'        => 'thread_id',
        ];

        return $structure;
    }

}