<?php

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2019
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\XF\Entity;

class Node extends XFCP_Node
{

    protected function _postSave()
    {
        parent::_postSave();
        $this->rebuildXCUANodeCache();
    }

    protected function _postDelete()
    {
        parent::_postDelete();
        $this->rebuildXCUANodeCache();
    }

    protected function rebuildXCUANodeCache()
    {
        /** @var \XenConcept\UserActivity\XF\Repository\Node $nodeRepo */
        $nodeRepo = $this->getNodeRepo();

        \XF::runOnce('contentTypeCacheRebuild', function() use ($nodeRepo)
        {
            $nodeRepo->rebuildXCUANodeCache();
        });
    }

}