<?php

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2017
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\XF\Entity;

use XF\Mvc\Entity\Structure;

/**
 * GETTERS
 * @property array totalViewers
 */
class Forum extends XFCP_Forum
{
    public function canViewViewersForum(&$error = null)
    {
        $visitor = \XF::visitor();
        return $visitor->hasNodePermission($this->node_id, 'viewersForumThreadList');
    }

    public function getTotalViewers()
    {
        if (!\XF::options()->xc_user_activity_enable_viewing_forum_home || !$this->canViewViewersForum())
        {
            return 0;
        }

        $xcUANode = $this->app()->container('xcUANode');

        if (isset($xcUANode[$this->node_id]) && $xcUANode[$this->node_id]['total'] != 0)
        {
            return $xcUANode[$this->node_id]['total'];
        }
        else
        {
            return 0;
        }
    }

    public function getNodeListExtras()
    {
        $output = parent::getNodeListExtras();

        $output['totalViewers'] = $this->totalViewers;

        return $output;
    }


    public static function getStructure(Structure $structure)
    {
        $structure = parent::getStructure($structure);

        $structure->getters['totalViewers'] = true;

        return $structure;
    }
}