<?php

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2019
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\Widget;
;
use XF\Widget\AbstractWidget;

class ThreadViewers extends AbstractWidget
{

    protected $threadId;

    public function render()
    {
        $session = \XF::session();
        if (!empty($session['robot']))
        {
            return '';
        }

        $this->threadId = $this->contextParams['thread']->thread_id;
        $viewersParams  = $this->runAndGetResult();

        $userCount   = $viewersParams['userCount'];
        $guestCount  = $viewersParams['guestCount'];
        $userViewers = $viewersParams['userViewers'];


        $title = \XF::phrase('xc_user_activity_users_who_are_viewing_this_thread_total_x_members_x_guests_x',
            [
                'total'       => $userCount + $guestCount,
                'totalMember' => $userCount,
                'totalGuest'  => $guestCount
            ]
        );

        $options = \XF::options();

        $viewParams = [
            'title'         => $title,
            'userViewers'   => $userViewers,
            'removeFooter'  => $options->xc_user_activity_viewing_thread_remove_footer,
            'userDisplay'   => $options->xc_user_activity_display_users_viewing,
            'currentUser'   => $viewersParams['currentUser']
        ];
        return $this->renderer('xc_user_activity_thread_viewers_widget', $viewParams);
    }

    protected function runAndGetResult()
    {
        $nodeSessionActivityRepo = $this->getNodeSessionActivityRepo();
        $threadViewersFinder = $nodeSessionActivityRepo->findUserNodeSessionActivityForXViewers()
            ->where('content_id', $this->threadId)
            ->where('content_type', 'thread');

        $user = \XF::visitor();
        if ($user->user_id)
        {
            $threadViewersFinder
                ->where('user_id', '!=', $user->user_id);
        }

        $threadViewers = $threadViewersFinder->fetch();
        $userCount = $threadViewers->count();

        if ($user->user_id)
        {
            $userCount++;
        }

        $guestCount = $nodeSessionActivityRepo->countUserNodeSessionActivityForXViewers(null,'thread', $this->threadId);

        return [
            'userViewers'  => $threadViewers,
            'userCount'    => $userCount,
            'guestCount'   => $guestCount,
            'currentUser'  => $user
        ];
    }

    /**
     * @return \XenConcept\UserActivity\Repository\NodeSessionActivity|\XF\Mvc\Entity\Repository
     */
    protected function getNodeSessionActivityRepo()
    {
        return $this->repository('XenConcept\UserActivity:NodeSessionActivity');
    }

    /**
     * @return string|null
     */
    public function getOptionsTemplate()
    {
        return 'admin:xc_user_activity_widget_def_options_' . $this->widgetConfig->definitionId;
    }
}