<?php

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2017
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\Widget;

use XF\Widget\AbstractWidget;

class ThreadReaders extends AbstractWidget
{

    protected $threadId;
    protected $userId;

    public function render()
    {
        $session = \XF::session();
        if (!empty($session['robot']))
        {
            return '';
        }

        $thread  = $this->contextParams['thread'];
        $options = \XF::options();

        $this->threadId = $thread->thread_id;
        $this->userId = $thread->user_id;

        $readersParams = $this->runAndGetResult($options);

        $title = \XF::phrase('xc_user_activity_who_read_this_thread_total_members_x', ['total' => $readersParams['totalReaders']]);

        if (!$readersParams['countReaders'])
        {
            return '';
        }


        $viewParams = [
            'thread' => $thread,
            'title'  => $title,
            'userDisplay' => $options->xc_user_activity_display_users_reader,
        ] + $readersParams;
        return $this->renderer('xc_user_activity_thread_readers_widget', $viewParams);
    }

    protected function runAndGetResult($options)
    {
        $threadRepo = $this->getThreadRepo();
        $threadReadFinder = $threadRepo->findThreadReadersByThreadId($this->threadId, $this->userId);

        $readersLimit = $options->xc_user_activity_readers_limit;
        if ($readersLimit)
        {
            $threadReaders = $threadReadFinder->limit($readersLimit)->fetch();
        }
        else
        {
            $threadReaders = $threadReadFinder->fetch();
        }

        return [
            'totalReaders'  => $threadReadFinder->total(),
            'threadReaders' => $threadReaders,
            'countReaders'  => $threadReaders->count()
        ];
    }

    /**
     * @return string|null
     */
    public function getOptionsTemplate()
    {
        return 'admin:xc_user_activity_widget_def_options_' . $this->widgetConfig->definitionId;
    }

    /**
     * @return \XenConcept\UserActivity\XF\Repository\Thread
     */
    protected function getThreadRepo()
    {
        return $this->repository('XF:Thread');
    }
}