<?php
/**
 * Created by PhpStorm.
 * User: Rémi
 * Date: 17/04/2018
 * Time: 20:06
 */

namespace XenConcept\UserActivity\Widget;

use XenConcept\UserActivity\XF\Entity\Thread;
use XF\Widget\AbstractWidget;

class RepliedThread extends AbstractWidget
{

    public function render()
    {
        $session = \XF::session();
        if (!empty($session['robot']))
        {
            return '';
        }

        /** @var \XF\Entity\Thread $thread */
        $thread  = $this->contextParams['thread'];
        $threadRepo = $this->getThreadRepo();
        $options = \XF::options();

        $threadRepliesFinder = $threadRepo->findThreadRepliesByThreadId($thread->thread_id, $thread->user_id);

        $repliesTotal = $threadRepliesFinder->total();

        $repliesLimit = $options->xc_user_activity_replies_limit;
        if ($repliesLimit)
        {
            $threadReplies = $threadRepliesFinder->limit($repliesLimit)->fetch();
        }
        else
        {
            $threadReplies = $threadRepliesFinder->fetch();
        }

        $countThreadReplies = $threadReplies->count();

        if ($countThreadReplies === 0)
        {
            return '';
        }

        $title = \XF::phrase('xc_user_activity_user_who_replied_this_thread_total_member_x', ['totalMember' => $repliesTotal]);

        $viewParams = [
            'title' => $title,
            'replies' => $threadReplies,
            'totalReplies' => $repliesTotal,
            'countReplies' => $countThreadReplies,
            'userDisplay' => $options->xc_user_activity_display_users_replied,
            'thread' => $thread
        ];
        return $this->renderer('xc_user_activity_thread_replies_widget', $viewParams);
    }

    /**
     * @return string|null
     */
    public function getOptionsTemplate()
    {
        return 'admin:xc_user_activity_widget_def_options_' . $this->widgetConfig->definitionId;
    }

    /**
     * @return \XenConcept\UserActivity\XF\Repository\Thread
     */
    protected function getThreadRepo()
    {
        return $this->repository('XF:Thread');
    }
}