<?php
/**
 * Created by PhpStorm.
 * User: Remi
 * Date: 31/07/2019
 * Time: 20:49
 */

namespace XenConcept\UserActivity\Widget;

use XF\Widget\AbstractWidget;

class ProjectReaders extends AbstractWidget
{
    protected $projectId;
    protected $userId;

    public function render()
    {
        $session = \XF::session();
        if (!empty($session['robot']))
        {
            return '';
        }

        $project  = $this->contextParams['project'];
        $options = \XF::options();

        $this->projectId = $project->project_id;
        $this->userId = $project->user_id;

        $readersParams = $this->runAndGetResult($options);

        $title = \XF::phrase('xc_user_activity_who_read_this_project_total_members_x', ['total' => $readersParams['totalReaders']]);

        if (!$readersParams['countReaders'])
        {
            return '';
        }


        $viewParams = [
                'project' => $project,
                'title'  => $title,
                'userDisplay' => $options->xc_user_activity_display_users_reader_project,
            ] + $readersParams;
        return $this->renderer('xc_user_activity_project_readers_widget', $viewParams);
    }

    protected function runAndGetResult($options)
    {
        $projectRepo = $this->getProjectRepo();
        $projectReadFinder = $projectRepo->findProjectReadersByProjectId($this->projectId, $this->userId);

        $readersLimit = $options->xc_user_activity_readers_limit_project;
        if ($readersLimit)
        {
            $projectReaders = $projectReadFinder->limit($readersLimit)->fetch();
        }
        else
        {
            $projectReaders = $projectReadFinder->fetch();
        }

        return [
            'totalReaders'  => $projectReadFinder->total(),
            'projectReaders' => $projectReaders,
            'countReaders'  => $projectReaders->count()
        ];
    }

    /**
     * @return string|null
     */
    public function getOptionsTemplate()
    {
        return 'admin:xc_user_activity_widget_def_options_' . $this->widgetConfig->definitionId;
    }

    /**
     * @return \XenConcept\ProjectManager\Repository\ProjectItem
     */
    protected function getProjectRepo()
    {
        return $this->repository('XenConcept\ProjectManager:ProjectItem');
    }
}