<?php

namespace XenConcept\UserActivity;

use XF\AddOn\AbstractSetup;
use XF\AddOn\StepRunnerInstallTrait;
use XF\AddOn\StepRunnerUninstallTrait;
use XF\AddOn\StepRunnerUpgradeTrait;
use XF\Db\Schema\Alter;
use XF\Db\Schema\Create;

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2017
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

class Setup extends AbstractSetup
{

    use StepRunnerInstallTrait;
    use StepRunnerUpgradeTrait;
    use StepRunnerUninstallTrait;

	public function installStep1()
	{
		$this->createWidget('xc_user_activity_viewers', 'xc_user_activity_viewers', []);
        $this->createWidget('xc_user_activity_readers', 'xc_user_activity_readers', []);
        $this->createWidget('xc_user_activity_view_for', 'xc_user_activity_view_for', []);
        $this->createWidget('xc_user_activity_replied', 'xc_user_activity_replied', []);
        $this->createWidget('xc_ua_project_viewers',
            'xc_ua_project_viewers', []);
        $this->createWidget('xc_ua_project_readers',
            'xc_ua_project_readers', []);
	}

	public function installStep2()
    {
        $this->schemaManager()->createTable('xf_xc_ua_node_session_activity', function (Create $table)
        {
            $table->engine('MEMORY');

            $table->addColumn('user_id', 'int');
            $table->addColumn('unique_key', 'varbinary', 16);
            $table->addColumn('ip', 'varbinary', 16)->setDefault('');
            $table->addColumn('content_type',' enum')->values(['thread', 'node', 'project', 'project_category']);
            $table->addColumn('parent_id', 'int')->setDefault(0);
            $table->addColumn('content_id', 'int')->setDefault(0);
            $table->addColumn('view_state', 'enum')->values(['valid','error']);
            $table->addColumn('view_date', 'int');
            $table->addPrimaryKey(['user_id', 'unique_key'])->using('btree');
            $table->addKey('view_date')->using('btree');
        });
    }

	public function upgrade2000200Step1()
    {
        $this->deleteWidget('xc_user_activity_view_for');
        $this->createWidget('xc_user_activity_view_for', 'xc_user_activity_view_for', []);
    }

    public function upgrade2000400Step1()
    {
        $this->deleteWidget('xc_user_activity_view_for');
        $this->createWidget('xc_user_activity_view_for', 'xc_user_activity_view_for', []);
    }

    public function upgrade2001000Step1()
    {
        $this->createWidget('xc_user_activity_replied', 'xc_user_activity_replied', []);
    }

    public function upgrade2001334Step1()
    {
        $this->schemaManager()->createTable('xf_xc_ua_node_session_activity', function (Create $table)
        {
            $table->engine('MEMORY');

            $table->addColumn('user_id', 'int');
            $table->addColumn('unique_key', 'varbinary', 16);
            $table->addColumn('ip', 'varbinary', 16)->setDefault('');
            $table->addColumn('content_type',' enum')->values(['thread', 'node', 'project', 'project_category']);
            $table->addColumn('parent_id', 'int')->setDefault(0);
            $table->addColumn('content_id', 'int')->setDefault(0);
            $table->addColumn('view_state', 'enum')->values(['valid','error']);
            $table->addColumn('view_date', 'int');
            $table->addPrimaryKey(['user_id', 'unique_key'])->using('btree');
            $table->addKey('view_date')->using('btree');
        });
    }

    public function upgrade2001335Step1()
    {
        $this->schemaManager()->createTable('xf_xc_ua_node_session_activity', function (Create $table)
        {
            $table->engine('MEMORY');

            $table->addColumn('user_id', 'int');
            $table->addColumn('unique_key', 'varbinary', 16);
            $table->addColumn('ip', 'varbinary', 16)->setDefault('');
            $table->addColumn('content_type',' enum')->values(['thread', 'node', 'project', 'project_category']);
            $table->addColumn('parent_ids', 'int')->setDefault(0);
            $table->addColumn('content_id', 'int')->setDefault(0);
            $table->addColumn('view_state', 'enum')->values(['valid','error']);
            $table->addColumn('view_date', 'int');
            $table->addPrimaryKey(['user_id', 'unique_key'])->using('btree');
            $table->addKey('view_date')->using('btree');
        });
    }

    public function upgrade2001336Step1()
    {
        $this->schemaManager()->createTable('xf_xc_ua_node_session_activity', function (Create $table)
        {
            $table->checkExists(true);

            $table->engine('MEMORY');

            $table->addColumn('user_id', 'int');
            $table->addColumn('unique_key', 'varbinary', 16);
            $table->addColumn('ip', 'varbinary', 16)->setDefault('');
            $table->addColumn('content_type',' enum')->values(['thread', 'node', 'project', 'project_category']);
            $table->addColumn('parent_id', 'int')->setDefault(0);
            $table->addColumn('content_id', 'int')->setDefault(0);
            $table->addColumn('view_state', 'enum')->values(['valid','error']);
            $table->addColumn('view_date', 'int');
            $table->addPrimaryKey(['user_id', 'unique_key'])->using('btree');
            $table->addKey('view_date')->using('btree');
        });
    }

    public function upgrade2001400Step1()
    {
        $this->schemaManager()->dropTable('xf_xc_ua_node_session_activity');
        $this->schemaManager()->createTable('xf_xc_ua_node_session_activity', function (Create $table)
        {
            $table->checkExists(true);

            $table->engine('MEMORY');

            $table->addColumn('user_id', 'int');
            $table->addColumn('unique_key', 'varbinary', 16);
            $table->addColumn('ip', 'varbinary', 16)->setDefault('');
            $table->addColumn('content_type',' enum')->values(['thread', 'node', 'project', 'project_category']);
            $table->addColumn('parent_id', 'int')->setDefault(0);
            $table->addColumn('content_id', 'int')->setDefault(0);
            $table->addColumn('view_state', 'enum')->values(['valid','error']);
            $table->addColumn('view_date', 'int');
            $table->addPrimaryKey(['user_id', 'unique_key'])->using('btree');
            $table->addKey('view_date')->using('btree');
        });

    }

    public function upgrade2001400Step2()
    {
        $this->createWidget('xc_ua_project_viewers',
            'xc_ua_project_viewers', []);
        $this->createWidget('xc_ua_project_readers',
            'xc_ua_project_readers', []);
    }

    public function upgrade2001491Step1()
    {
        $this->schemaManager()->dropTable('xf_xc_ua_node_session_activity');
        $this->schemaManager()->createTable('xf_xc_ua_node_session_activity', function (Create $table)
        {
            $table->checkExists(true);

            $table->engine('MEMORY');

            $table->addColumn('user_id', 'int');
            $table->addColumn('unique_key', 'varbinary', 16);
            $table->addColumn('ip', 'varbinary', 16)->setDefault('');
            $table->addColumn('content_type',' enum')->values(['thread', 'node', 'project', 'project_category']);
            $table->addColumn('parent_id', 'int')->setDefault(0);
            $table->addColumn('content_id', 'int')->setDefault(0);
            $table->addColumn('view_state', 'enum')->values(['valid','error']);
            $table->addColumn('view_date', 'int');
            $table->addPrimaryKey(['user_id', 'unique_key'])->using('btree');
            $table->addKey('view_date')->using('btree');
        });
    }

    public function upgrade2001494Step1()
    {
        $this->schemaManager()->dropTable('xf_xc_ua_node_session_activity');
        $this->schemaManager()->createTable('xf_xc_ua_node_session_activity', function (Create $table)
        {
            $table->checkExists(true);

            $table->engine('MEMORY');

            $table->addColumn('user_id', 'int');
            $table->addColumn('unique_key', 'varbinary', 16);
            $table->addColumn('ip', 'varbinary', 16)->setDefault('');
            $table->addColumn('content_type',' enum')->values(['thread', 'node', 'project', 'project_category']);
            $table->addColumn('parent_id', 'int')->setDefault(0);
            $table->addColumn('content_id', 'int')->setDefault(0);
            $table->addColumn('view_state', 'enum')->values(['valid','error']);
            $table->addColumn('view_date', 'int');
            $table->addPrimaryKey(['user_id', 'unique_key'])->using('btree');
            $table->addKey('view_date')->using('btree');
        });
    }

    public function uninstallStep1()
	{
        $this->deleteWidget('xc_user_activity_viewers');
        $this->deleteWidget('xc_user_activity_readers');
        $this->deleteWidget('xc_user_activity_view_for');
        $this->deleteWidget('xc_user_activity_replied');
        $this->deleteWidget('xc_ua_project_readers');
        $this->deleteWidget('xc_ua_project_viewers');
	}

	public function uninstallStep2()
    {
        $this->schemaManager()->dropTable('xf_xc_ua_node_session_activity');
    }

    protected function columnExist($table, $columnName)
    {
        return $this->db()->fetchRow('SHOW COLUMNS FROM ' . $table . ' WHERE Field = ?', $columnName);
    }
}