<?php
/**
 * Created by PhpStorm.
 * User: Remi
 * Date: 20/03/2019
 * Time: 19:56
 */

namespace XenConcept\UserActivity\Repository;

use XF\DevelopmentOutput\BbCode;
use XF\Mvc\Entity\Repository;

class NodeSessionActivity extends Repository
{


    protected $xfController = [
        'XF\Pub\Controller\Thread',
        'XF\Pub\Controller\Forum',
        'XF\Pub\Controller\Category',
    ];

    protected $xcController = [
        'XenConcept\ProjectManager\Pub\Controller\Category',
        'XenConcept\ProjectManager\Pub\Controller\ProjectItem'
    ];

    protected $allowedController = [
        'XF\Pub\Controller\Thread',
        'XF\Pub\Controller\Forum',
        'XF\Pub\Controller\Category',

        'XenConcept\ProjectManager\Pub\Controller\Category',
        'XenConcept\ProjectManager\Pub\Controller\ProjectItem'
    ];

    protected $allowedAction = [
        'Forum',
        'Index',
        'View'
    ];

    public function updateNodeSessionActivity($userId, $ip, $controller, $action, array $params, $viewState)
    {
        if (!in_array($controller, $this->allowedController))
        {
            $this->clearUserNodeActivity($userId, $ip);
            return;
        }

        if (!in_array($action, $this->allowedAction))
        {
            $this->clearUserNodeActivity($userId, $ip);
            return;
        }

        if ($viewState != 'valid')
        {
            return;
        }

        $contentId   = 0;
        $contentType = '';
        $parentId    = 0; // Category And Node

        // XF (Thread And Node)

        if (in_array($controller, $this->xfController))
        {
            $nodeId    = isset($params['node_id']) ? $params['node_id'] : null;
            $threadId  = isset($params['thread_id']) ? $params['thread_id'] : null;

            if ($nodeId || $threadId)
            {
                if ($nodeId)
                {
                    $contentId = 0;
                    $contentType = 'node';
                    $parentId  = $nodeId;
                }
                elseif ($threadId)
                {
                    $contentId   = $threadId;
                    $contentType = 'thread';
                    $parentId    = $this->getNodeIdByThreadId($threadId);
                }
            }
        }
        elseif (in_array($controller, $this->xcController))
        {
            $proCatId  = isset($params['project_category_id']) ? $params['project_category_id'] : null;
            $projectId = isset($params['project_id']) ? $params['project_id'] : null;

            if ($proCatId || $projectId)
            {
                if ($proCatId)
                {
                    $contentId = 0;
                    $contentType = 'project_category';
                    $parentId  = $proCatId;
                }
                elseif ($projectId)
                {
                    $contentId   = $projectId;
                    $contentType = 'project';
                    $parentId    = $this->getCategoryIdByProjectId($projectId);
                }
            }
        }

        if (!$contentId && !$parentId && !$contentType)
        {
            return;
        }

        $userId    = intval($userId);
        $binaryIp  = \XF\Util\Ip::convertIpStringToBinary($ip);
        $uniqueKey = ($userId ? $userId : $binaryIp);

        $this->db()->query("
			-- XFDB=noForceAllWrite
			INSERT INTO xf_xc_ua_node_session_activity
				(`user_id`, `unique_key`, `ip`, `content_type`, `parent_id`, `content_id`, `view_state`, `view_date`)
			VALUES
				(?, ?, ?, ?, ?, ?, ?, ?)
			ON DUPLICATE KEY UPDATE ip = VALUES(ip),
			    content_type = VALUES(content_type),
				parent_id = VALUES(parent_id),
				content_id = VALUES(content_id),
				view_state = VALUES(view_state),
				view_date = VALUES(view_date)
		", [$userId, $uniqueKey, $binaryIp, $contentType, $parentId, $contentId, $viewState, \XF::$time]);
        // TODO: swallow errors if upgrade is pending
    }

    protected function getNodeIdByThreadId($threadId)
    {
        return $this->db()->fetchOne("SELECT node_id FROM xf_thread WHERE thread_id = ?", [$threadId]);
    }

    protected function getCategoryIdByProjectId($projectId)
    {
        return $this->db()->fetchOne("SELECT project_category_id FROM xf_xcpm_project WHERE project_id = ?", [$projectId]);
    }

    public function pruneExpiredNodeActivityRecords($cutOff = null)
    {
        if ($cutOff === null)
        {
            $cutOff = \XF::$time - 3600;
        }

        $this->db()->delete('xf_xc_ua_node_session_activity', 'view_date < ?', $cutOff);
    }

    public function clearUserNodeActivity($userId, $ip)
    {
        $userId = intval($userId);
        $binaryIp = \XF\Util\Ip::convertIpStringToBinary($ip);
        $uniqueKey = ($userId ? $userId : $binaryIp);

        $this->db()->delete('xf_xc_ua_node_session_activity',
            'user_id = ? AND unique_key = ?',
            [$userId, $uniqueKey]
        );
    }

    // #################### THREAD AND FORUM VIEW VIEWERS ####################

    public function findUserNodeSessionActivityForXViewers()
    {
        /** @var \XenConcept\UserActivity\Finder\NodeSessionActivity $finder */
        $finder = $this->finder('XenConcept\UserActivity:NodeSessionActivity');
        $finder
            ->restrictType('member')
            ->activeOnly();

        return $finder;
    }

    public function countUserNodeSessionActivityForXViewers($contentTypes, $viewerType, $whereId)
    {
        /** @var \XenConcept\UserActivity\Finder\NodeSessionActivity $finder */
        $finder = $this->finder('XenConcept\UserActivity:NodeSessionActivity');


        if (is_null($contentTypes))
        {
            $finder->where('content_type', $viewerType);
        }
        else
        {
            $finder->where('content_type', $contentTypes);
        }

        if (in_array($viewerType, ['thread', 'project']))
        {
            $finder->where('content_id', $whereId);
        }
        else if (in_array($viewerType, ['node', 'project_category_id']))
        {
            $finder->where('parent_id', $whereId);
        }
        else
        {
            $finder->where('parent_id', $whereId);
        }

        $finder
            ->restrictType('guest')
            ->activeOnly();

        return $finder->total();
    }

    // #################### FORUM LIST VIEWERS ####################

    public function countUserNodeSessionActivityForForumListViewers()
    {
        $db = $this->db();
        $cutOff = \XF::$time - $this->app()->options()->onlineStatusTimeout * 60;

        $query = "
          SELECT parent_id, content_type, COUNT(*) AS total
          FROM `xf_xc_ua_node_session_activity`
          WHERE `view_date` >= {$cutOff}
          AND `content_type` in (" . $this->db()->quote(['node', 'thread']) . ")
          GROUP BY parent_id
        ";

        return $db->fetchAllKeyed($query, 'parent_id');
    }

}