<?php

/*************************************************************************
 * User activity (Users Viewed, Viewing Thread, Viewing Forum) - XenConcept (c) 2017
 * All Rights Reserved.
 **************************************************************************
 * This file is subject to the terms and conditions defined in the Licence
 * Agreement available at Try it like it buy it :)
 *************************************************************************/

namespace XenConcept\UserActivity\Entity;

use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Structure;

/**
 * COLUMNS
 * @property int user_id
 * @property string unique_key
 * @property string ip
 * @property string content_type
 * @property int parent_id
 * @property int content_id
 * @property string view_state
 * @property int view_date
 */
class NodeSessionActivity extends Entity
{

    public static function getStructure(Structure $structure)
    {
        $structure->table      = 'xf_xc_ua_node_session_activity';
        $structure->shortName  = 'XenConcept\UserActivity:NodeSessionActivity';
        $structure->primaryKey = ['user_id', 'unique_key'];
        $structure->columns = [
            'user_id' => ['type' => self::UINT, 'required' => true],
            'unique_key' => ['type' => self::STR, 'maxLength' => 16, 'required' => true],
            'ip' => ['type' => self::BINARY, 'maxLength' => 16, 'required' => true],
            'content_type' => ['type' => self::STR, 'required' => true,
                'allowedValues' => ['thread', 'node', 'project', 'project_category']
            ],
            'parent_id' => ['type' => self::STR, 'default' => 0],
            'content_id' => ['type' => self::STR, 'default' => 0],
            'view_state' => ['type' => self::STR, 'required' => true,
                'allowedValues' => ['valid', 'error']
            ],
            'view_date' => ['type' => self::UINT, 'required' => true],
        ];
        $structure->getters = [
            'description' => true,
            'item_title' => true,
            'item_url' => true
        ];
        $structure->relations = [
            'User' => [
                'entity' => 'XF:User',
                'type' => self::TO_ONE,
                'conditions' => 'user_id',
                'primary' => true
            ],
        ];

        return $structure;
    }

}