<?php
namespace XenBulletins\Core\Licensing\Engine;

use XenBulletins\Core\Licensing\Checker;
use XenBulletins\Core\Licensing\Exception\LicenseFailedException;
use XenBulletins\Core\Licensing\LicenseData;
use XenBulletins\Core\Licensing\StorageDriver\AbstractStorageDriver;
use XenBulletins\Core\Licensing\StorageDriver\Database;
use XenBulletins\Core\Licensing\StorageDriver\File;


abstract class AbstractEngine implements AbstractEngineInterface
{
    public static function getEndpoint() {
        return '';
    }

     public static function getAddonId() {
        return '';
    }
    public static function getLicenseChecker()
    {
       
        // check for existing license
        $checker = new Checker(
            static::getDrivers()
        );

        $checker->setEndpoint(static::getEndpoint());
        $checker->setAddonId(static::getAddonId());
        $checker->setBoardHost(static::getBoardDomain());

        return $checker;
    }

    public static function installDrivers()
    {
        
        foreach (static::getDrivers() AS $driver) {
           
            $driver->install();
        }
    }

    public static function getInvalidLicenseMessage($addonName)
    {
        return '<a style="color: red" href="https://xenbulletins.com/index.php/" target="_blank">' . $addonName . ': invalid license detected.</a>';
    }

    public static function getExpiredTrialMessage($addonName)
    {
        return '<a style="color: red" href="https://xenbulletins.com/index.php/" target="_blank">' . $addonName . ': your trial version is expired.</a>';
    }

    public static function getLicenseEmptyMessage($addonName)
    {
        return '<a style="color: red" href="https://customers.addonslab.com/submitticket.php" target="_blank">' . $addonName
            . ': please enter your license key in Admin Panel.</a>';
    }

    public static function getBrandingMessage($addonName)
    {
        return '<a class="concealed" href="https://customers.addonslab.com/marketplace.php" target="_blank">' . $addonName . '</a>';
    }

    /**
     * @param $licenseKey
     * @param bool $logFailure
     * @return \AddonsLab\Licensing\LicenseData
     * @throws DataIntegrityException
     * @throws LicenseFailedException Does full re-validation and throws exceptions in case of failure
     */
    public static function licenseLocalReValidation($licenseKey, $logFailure = true)
    {
        $checker = static::getLicenseChecker();

        $licenseData = $checker->getLocalLicenseData($licenseKey);
        if ($licenseData->isValid() === false && $logFailure === true) {
            $licenseData->increaseFailCount();
	        $checker->setLicenseData($licenseKey, $licenseData);
	        if ($licenseData->isFailed()) {
		        throw new LicenseFailedException();
	        }
        }

        return $licenseData;
    }

    /**
     * @param $licenseKey
     * @param bool $logFailure
     * @return \AddonsLab\Licensing\LicenseData
     * @throws DataIntegrityException
     * @throws LicenseFailedException Does full re-validation and throws exceptions in case of failure
     */
    public static function licenseReValidation($licenseKey, $logFailure = true)
    {
        $checker = static::getLicenseChecker();
       
        $licenseData = $checker->forceLicenseUpdate($licenseKey);
  
        if ($licenseData->isValid() === false && $logFailure === true) {
            
            $licenseData->increaseFailCount();
        }
      
        $checker->setLicenseData($licenseKey, $licenseData);
 
        if ($licenseData->isFailed()) {
           
            throw new LicenseFailedException();
        }

        return $licenseData;
    }
}
