<?php

namespace XP\VB\XF\Template;


class Templater extends XFCP_Templater
{
	public function fnUsernameLink($templater, &$escape, $user, $rich = false, $attributes = [])
	{
		$username = parent::fnUsernameLink($templater, $escape, $user, $rich, $attributes);
		$visitor = \XF::visitor();

		if (!$user)
		{
			return $username;
		}

		if (!is_object($user))
		{
			if (!isset($user['user_id']))
			{
				return $username;
			}

			$user = \XF::em()->instantiateEntity('XF:User', $user);
		}

		/** @var \XP\VB\XF\Entity\User $user */
		if ($user instanceof \XF\Entity\User)
		{
			$vB = '';
			$hasVB = 0;
			$options = \XF::options();
			$vbType = $options->xpVbType;

			if ($visitor->hasPermission('view', 'XP_VB_Badge'))
			{
				$vbPhrase = $user->getVbPhrase();

				$tooltipParams[] = 'data-original-title="' . $vbPhrase . '"';
				if ($options->XPVB_allowHtml)
				{
					$tooltipParams[] = 'data-html="true"';
				}

				if ($vbType == 'default')
				{
					$vB = '<i data-xf-init="tooltip"' . implode(' ', $tooltipParams) . '" class="fa--xf far fa-check-circle fa-lg fa-fw xpvb" aria-hidden="true"></i>';
				}
				else if ($vbType == 'icon')
				{
					$fa = $options->xpCustomVbIcon;
					if (!in_array(substr($fa, 0, 3), ['fas', 'far', 'fal', 'fad']))
					{
						$fa = "far $fa";
					}

					$vB = '<i data-xf-init="tooltip"' . implode(' ', $tooltipParams) . '" class="fa--xf ' . $fa . ' fa-lg fa-fw xpvb" aria-hidden="true"></i>';
				}
				else if ($vbType == 'image')
				{
					$vB = '<img data-xf-init="tooltip"' . implode(' ', $tooltipParams) . ' src="' . $options->xpCustomVbImage . '" style="width: 20px; margin-bottom: -5px;" class="xpvb" aria-hidden="true" />';
				}
			}

			if ($user['xp_vb_is_verified'])
			{
				$hasVB = true;
			}

			if ($hasVB)
			{
				if ($options->xpVB_location == 'left')
				{
					$username = $vB . $username;
				}
				else
				{
					$username = $username . $vB;
				}

			}
		}

		return $username;
	}
}