<?php

namespace XP\VB\Entity;

use XF\Mvc\Entity\Structure;

class RequestField extends \XF\Entity\AbstractField
{
	protected function getClassIdentifier()
	{
		return 'XP\VB:RequestField';
	}

	protected static function getPhrasePrefix()
	{
		return 'xp_vb_request_field';
	}

	protected function _postDelete()
	{
		$this->db()->delete('xf_xp_vb_request_field_value', 'field_id = ?', $this->field_id);

		parent::_postDelete();
	}


	public static function getStructure(Structure $structure)
	{
		self::setupDefaultStructure(
			$structure,
			'xf_xp_vb_request_field',
			'XP\VB:RequestField',
			[
				'groups' => ['above_message', 'below_message'],
				'has_wrapper_template' => true
			]
		);

		return $structure;
	}
}