<?php

use XF\Pub\App;
use XF\Sitemap\Renderer;

$dir = __DIR__;
require $dir . '/src/XF.php';

try {
    \XF::start($dir);
    $app = \XF::setupApp(App::class);
    
    // Check if sitemap renderer service exists
    if (!$app->offsetExists('sitemap.renderer')) {
        throw new \Exception('Sitemap renderer service not available');
    }
    
    /** @var Renderer $renderer */
    $renderer = $app['sitemap.renderer'];
    $request = $app->request();
    $response = $app->response();
    
    // Get and validate counter parameter
    $counter = $request->filter('c', 'uint');
    if ($counter < 0) {
        $counter = 0;
    }
    
    // Generate sitemap
    $response = $renderer->outputSitemap($response, $counter);
    
    // Ensure proper headers for XML sitemap
    $response->header('Content-Type', 'application/xml; charset=utf-8');
    
    $response->send($request);
    
} catch (\Exception $e) {
    // Log error and return appropriate response
    error_log('Sitemap generation error: ' . $e->getMessage());
    
    if (isset($app)) {
        $response = $app->response();
        $response->httpCode(500);
        $response->body('Sitemap generation failed');
        $response->send($request ?? $app->request());
    } else {
        http_response_code(500);
        echo 'Sitemap generation failed';
    }
}