<?php
// forum_bot_gelismis_V9.0.php - Ultra Pro İlan Botu (Dinamik Forum URL ve Gelişmiş Loglama)

// --- AYARLAR, LOGLAMA VE BAYRAK TANIMLAMA ---
$log_file = dirname(__FILE__) . "/bot_log.txt";
$stop_flag_file = dirname(__FILE__) . "/bot_stop.flag"; 
$cookie_file = dirname(__FILE__) . '/xf_cookies.txt'; // Her zaman botun yanında olmalı

function log_message($message) {
    global $log_file;
    file_put_contents($log_file, date("[Y-m-d H:i:s]") . " " . $message . "\n", FILE_APPEND);
}

log_message("--- BOT İŞLEM BAŞLANGICI (V9.0) ---");


// --- KRİTİK: ADMIN PANELİNDEN GELEN AYARLARI YÜKLEME ---

$admin_settings = [];
if (file_exists('bot_settings.json')) {
    $settings_json = file_get_contents('bot_settings.json');
    $admin_settings = json_decode($settings_json, true);
}

if (!$admin_settings) {
    log_message(" ❌ KRİTİK HATA: Ayarlar dosyası (bot_settings.json) okunamadı veya JSON formatı bozuk.");
    log_message("--- BOT İŞLEMİ SONLANDI (HATA) ---");
    exit;
}

// Ayarları çek
$forum_url = $admin_settings['forum_url'] ?? "https://fallback.forum.net/"; // V5.0 Yeni: Dinamik URL
$kategori_id = (int)($admin_settings['category_id'] ?? 1068);
$konu_kategorisi = $admin_settings['target_category_name'] ?? "Varsayılan Kategori"; // V5.0 Yeni
$run_count = $admin_settings['ilan_sayisi'] ?? 1;
$openai_api_key = $admin_settings['api_key'] ?? "sk-proj-FALLBACK";
$kullanici_adi = $admin_settings['username'] ?? "admin";
$sifre = $admin_settings['password'] ?? "1453";
$model_adi_metin = $admin_settings['gpt_model'] ?? "gpt-4o";
$model_adi_gorsel = "dall-e-3";
$dalle_kalite = $admin_settings['dalle_quality'] ?? "hd";
$dalle_boyut = $admin_settings['dalle_size'] ?? "1024x1024";
$dalle_stil = $admin_settings['dalle_style'] ?? "natural";
$selected_platform_filter = $admin_settings['platform'] ?? 'Tümü (Rastgele)';
$delay_seconds = (int)($admin_settings['delay_seconds'] ?? 15);
$temperature = (float)($admin_settings['temperature'] ?? 0.8);
$max_tokens = (int)($admin_settings['max_tokens'] ?? 3500);
$seed = (int)($admin_settings['seed'] ?? 42);
$forum_signature = $admin_settings['forum_signature'] ?? "";

log_message("⚙️ Ayarlar yüklendi. Hedef: **{$forum_url}** (ID: {$kategori_id}, Kategori: {$konu_kategorisi}).");
log_message(" -> {$run_count} ilan üretimi için hazır. T: {$temperature}, MaxT: {$max_tokens}, Gecikme: {$delay_seconds}s");


// --- TEMEL FORUM FONKSİYONLARI ---
function get_xf_token($url, $ch) {
    // xf_token, her sayfadan alınabildiği için güvenilir bir şekilde alınmaya çalışılır.
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $html = curl_exec($ch);
    
    // Hata kontrolü
    if(curl_errno($ch)) {
        log_message(" ❌ KRİTİK HATA (Token Alma): cURL hatası: " . curl_error($ch));
        return false;
    }

    if (preg_match('/name="_xfToken" value="([^"]+)"/i', $html, $matches)) {
        return $matches[1];
    }
    
    // Token bulunamama durumunda HTML içeriğinde "login" formunun olup olmadığı kontrol edilir (oturumun kapanmış olabileceği ihtimali).
    if(strpos($html, '<form action="login/login" method="post"') !== false) {
        log_message(" ❌ KRİTİK HATA (Token Alma): Sayfada login formu bulundu. Oturum kapalı veya URL hatalı.");
    }
    return false;
}

function oturum_ac() {
    global $forum_url, $kullanici_adi, $sifre, $cookie_file;
    // URL'nin sonunda "/" olup olmadığını kontrol et ve ekle
    $clean_forum_url = rtrim($forum_url, '/') . '/';
    $login_url = $clean_forum_url . "login/login";
    
    $ch = curl_init();
    // Gelişmiş cURL ayarları
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie_file);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie_file);

    log_message("Oturum açılıyor: Kullanıcı '{$kullanici_adi}'");
    $xf_token = get_xf_token($login_url, $ch);
    
    if (!$xf_token) {
        log_message(" ❌ KRİTİK HATA: Giriş token'ı bulunamadı. URL'yi kontrol edin: {$clean_forum_url}");
        curl_close($ch);
        return false;
    }
    
    $login_data = [
        'login' => $kullanici_adi,
        'password' => $sifre,
        'remember' => 1,
        '_xfToken' => $xf_token,
        '_xfRedirect' => $clean_forum_url,
    ];
    
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded', 'Referer: ' . $login_url]);
    curl_setopt($ch, CURLOPT_URL, $login_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($login_data));

    $response = curl_exec($ch);
    
    // Başarılı giriş kontrolü: response'da kullanıcı adının geçmesi ve login formunun olmaması (basitleştirilmiş)
    if (strpos($response, $kullanici_adi) !== false && strpos($response, 'login/login') === false) {
        log_message(" -> Oturum başarıyla açıldı.");
        return $ch;
    } else {
        log_message(" ❌ HATA: Oturum açılamadı. Kullanıcı adı/Şifre veya Token hatası olabilir.");
        
        if (preg_match('/<div class="block-body">(.*?)<\/div>/s', $response, $matches)) {
             log_message("   🚨 FORUM HATA MESAJI (Dönüş): " . strip_tags($matches[1]));
        }
        curl_close($ch);
        return false;
    }
}


// --- DALL-E GÖRSEL ÜRETİM FONKSİYONU ---
function dall_e_ile_resim_uret(string $prompt, string $api_key, string $model, string $quality, string $size, string $style): string
{
    log_message(" 🖼️ DALL-E API'ye resim üretim isteği gönderiliyor (Kalite: {$quality}, Boyut: {$size}, Stil: {$style})...");
    
    $api_endpoint = "https://api.openai.com/v1/images/generations";
    $hata_resmi = 'https://placehold.co/1024x576/FF5733/FFFFFF?text=Gorsel+Uretilemedi'; 

    $payload = json_encode([
        'model' => $model,
        'prompt' => $prompt,
        'n' => 1, 
        'size' => $size, 
        'quality' => $quality, 
        'style' => $style,
        'response_format' => 'url'
    ]);

    $ch_api = curl_init($api_endpoint);
    curl_setopt($ch_api, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch_api, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch_api, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch_api, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        "Authorization: Bearer {$api_key}", 
    ]);
    
    $response = curl_exec($ch_api);
    $http_code = curl_getinfo($ch_api, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch_api); 
    curl_close($ch_api);

    if ($http_code != 200 || !$response) {
        log_message(" ❌ DALL-E HATA: HTTP Kodu {$http_code}. cURL Hata: {$curl_error}. Yanıt: " . substr($response, 0, 100) . "...");
        return $hata_resmi; 
    }
    
    $data = json_decode($response, true);
    $resim_url = $data['data'][0]['url'] ?? $hata_resmi;

    log_message(" ✅ Resim URL'si başarıyla alındı.");
    return $resim_url;
}


// --- GPT METİN & PROMPT ÜRETİM FONKSİYONU ---

function openai_ile_random_ilan_uret(string $kategori, string $api_key, string $model_adi, string $platform_filter, float $temperature, int $max_tokens, int $seed) 
{
    log_message(" 🤖 OpenAI API'den ultra profesyonel ilan paketi talep ediliyor (Model: {$model_adi}, Temp: {$temperature}, MaxT: {$max_tokens})...");

    $platformlar = [
        'Instagram (Niş E-Ticaret)', 'TikTok (Yüksek Etkileşimli Viral)', 'Facebook Sayfası (Kâr Garantili)', 
        'Telegram Kanalı (Kripto/Finans)', 'YouTube Kanalı (Eğitim/Tutorial)',
        'Twitch Kanalı (Esports/Gaming)', 'Discord Sunucusu (Geliştirici Topluluğu)' 
    ];
    
    if ($platform_filter !== 'Tümü (Rastgele)' && in_array($platform_filter, $platformlar)) {
        $platformlar = [$platform_filter];
    }
    
    // Daha profesyonel ve çeşitli rastgele veriler
    $takipci_sayilari = [22000, 58000, 135000, 310000, 550000, 800000, 1200000];
    $kurulus_yillari = ['2016', '2018', '2020', '2022', '2023', '2024'];
    $icerik_kitleleri = ['Türkiye - Niş E-Ticaret (AB Kitle)", "ABD/Global - Kripto Para & NFT', 'Global - Yapay Zeka & Makine Öğrenimi', 'Türkiye - Lüks Yaşam & Gayrimenkul', 'Avrupa - Minimalist Sanat & Dizayn', 'Global - Vegan Tarifler & Sürdürülebilirlik'];
    $aktiflik = ['Ultra Aktif (Ort. %15 Etkileşim)', 'Yüksek Etkileşim (Ort. %8 Etkileşim)', 'Orta Aktif', 'Pasifize Edildi (Yeniden Canlandırmaya Uygun)'];
    $ilan_temalari = ['Acil Nakit İhtiyacından Satılık', 'Yeni Proje Finansmanı İçin Yatırım Fırsatı', 'Niş Pazarda Liderlik Etme Şansı', 'Sıfırdan Başlamaktan Kurtulun: Hazır Ciro Potansiyeli'];
    $fiyat_taban = rand(15, 150) * 1000; $fiyat_küsürat = rand(0, 3) * 250; $fiyat = $fiyat_taban + $fiyat_küsürat;

    $secilen_platform = $platformlar[array_rand($platformlar)];
    $secilen_takipci = number_format($takipci_sayilari[array_rand($takipci_sayilari)], 0, ',', '.');
    $secilen_yil = $kurulus_yillari[array_rand($kurulus_yillari)];
    $secilen_kitle = $icerik_kitleleri[array_rand($icerik_kitleleri)];
    $secilen_aktiflik = $aktiflik[array_rand($aktiflik)];
    $secilen_fiyat = number_format($fiyat, 0, ',', '.') . ' TL';
    $secilen_tema = $ilan_temalari[array_rand($ilan_temalari)];
    $rand_username = "@ProAcc" . rand(100, 999) . str_replace([' ', ':', '/', '(', ')', 'Ş', 'İ', 'Ğ', 'Ö', 'Ç', 'Ü'], '', substr(strtoupper($secilen_platform), 0, 4)); 

    $prompt = "Sen, '{$kategori}' için uzman, profesyonel, güven odaklı, yatırımcı dilini çok iyi kullanan, abartıdan uzak, detaylı ve güncel bir ilan metni yazarı ve görsel promptu oluşturucusunsun. İlanın genel temasını '{$secilen_tema}' olarak belirle. İlanın amacı yüksek kârlılık vadeden bir yatırım fırsatı sunmaktır.\n\n";
    $prompt .= "Aşağıdaki kritik verilere dayanarak, abartıdan uzak, yatırımcının dikkatini çekecek, detaylı ve profesyonel bir satış ilanı hazırla.\n\n";
    $prompt .= "--- İlanın Kritik Teknik Verileri ---\n";
    $prompt .= "Platform: {$secilen_platform}\nHesap Adı Örneği: {$rand_username}\nTakipçi Sayısı: {$secilen_takipci}\nKuruluş Yılı: {$secilen_yil}\nNiş Kitle ve İçerik: {$secilen_kitle}\nAktiflik Durumu: {$secilen_aktiflik}\nFiyat: {$secilen_fiyat}\nİlan Teması: {$secilen_tema}\n\n";
    $prompt .= "İstekler:\n1. Başlık: En fazla 15 kelime, yatırım fırsatını vurgulayan, SEO uyumlu.\n2. İçerik: **Minimum 550 kelime**, profesyonel HTML formatında. İçerik, ilan tablosunun hemen altında iki zorunlu alt başlık içermeli: <h5>Yatırımın Geri Dönüş Potansiyeli (ROI Analizi)</h5> ve <h5>Hukuki ve Güvenli Devir Prosedürü</h5>. Metin içinde **aylık ortalama net gelir, trafik/erisim kaynağı ve büyüme trendi gibi profesyonel istatistiklere** değin. İlan tablosuna HTML stil ve kenarlıklarını (border=\"1\" cellpadding=\"12\" style=\"width:100%; border-collapse: collapse; background-color: #f9f9f9;\") ekle. WhatsApp iletişim numarasını **+90 5XX XXX XX XX** olarak kullan.\n3. Etiketler: İlanın niş pazarı, platformu ve fiyatına özel, **çok teknik, SEO uyumlu ve güncel 15 adet** popüler etiket (virgül ile ayrılmış, Türkçe). Etiketler forumun ana etiketleri olarak kullanılacak.\n4. Resim Promptu: İlanı en iyi temsil eden, **{$rand_username}** kullanıcı adının geçtiği, yüksek çözünürlüklü ve kurumsal bir görsel üretmek için İngilizce, 100 kelimeyi geçmeyen, detaylı bir DALL-E promptu oluştur. Görselin ana teması, lüks bir ofis ortamında, şık giyimli bir iş insanının masaüstü bilgisayarında **büyüme grafikleri, net ciro verileri, yatırım raporları** ve {$secilen_platform} profiline baktığı, koyu renkli ve kurumsal bir sahne olmalı. Kullanıcı adı ekranda çok belirgin olmalı. Görsel, güven ve profesyonellik yaymalı.\n\nÇıktıyı SADECE aşağıdaki JSON formatında ver, başka metin veya açıklama ekleme:\n{\n  \"baslik\": \"Başlık buraya\",\n  \"icerik_html\": \"<p>İçerik buraya.</p>\",\n  \"etiketler\": \"etiket1, etiket2, etiket3, ..., etiket15\",\n  \"resim_promptu\": \"DALL-E promptu buraya\"\n}";

    $api_endpoint = "https://api.openai.com/v1/chat/completions";

    $payload = json_encode([
        'model' => $model_adi,
        'messages' => [
            ['role' => 'system', 'content' => "Sen bir {$kategori} için güvenilir, kurumsal ilan metni ve görsel promptu yazarı ve SADECE JSON formatında yanıt vermeye odaklanmış bir asistansın."],
            ['role' => 'user', 'content' => $prompt]
        ],
        'response_format' => ['type' => 'json_object'], 
        'temperature' => $temperature, 
        'max_tokens' => $max_tokens, 
        'seed' => $seed, 
    ]);

    $ch_api = curl_init($api_endpoint);
    curl_setopt($ch_api, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch_api, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch_api, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch_api, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        "Authorization: Bearer {$api_key}", 
    ]);
    
    $response = curl_exec($ch_api);
    $http_code = curl_getinfo($ch_api, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch_api); 
    curl_close($ch_api);

    if ($http_code != 200 || !$response) {
        log_message(" ❌ GPT HATA: HTTP Kodu {$http_code}. cURL Hata: {$curl_error}. API Anahtarınızı kontrol edin.");
        return false;
    }
    
    $data = json_decode($response, true);
    $json_content = $data['choices'][0]['message']['content'] ?? null;
    $ai_cikti = json_decode($json_content, true);

    if ($ai_cikti && isset($ai_cikti['baslik'], $ai_cikti['icerik_html'], $ai_cikti['etiketler'], $ai_cikti['resim_promptu'])) {
        log_message(" ✅ İlan Paketi (Metin + Prompt) başarıyla alındı.");
        return $ai_cikti;
    } else {
        log_message(" ❌ GPT HATA: Yanıt JSON formatında değil veya eksik anahtar var. Muhtemel AI/Prompt hatası. Ham yanıt: " . substr($json_content, 0, 200));
        return false;
    }
}

function konu_ac($ch, $kategori_id, $baslik, $icerik, $etiketler) {
    global $forum_url;
    
    $clean_forum_url = rtrim($forum_url, '/') . '/';
    $create_url = $clean_forum_url . "forums/{$kategori_id}/post-thread";
    $xf_token = get_xf_token($create_url, $ch);
    
    if (!$xf_token) {
        log_message(" ❌ HATA: Konu açma token'ı (_xfToken) bulunamadı. Kategori URL'sini kontrol edin: {$create_url}");
        return false;
    }
    
    $thread_data = [
        'title' => $baslik,
        'message_html' => $icerik, 
        'tags' => $etiketler,       
        '_xfToken' => $xf_token,
        'watch_thread' => 1,
    ];
    
    log_message(" Yeni konu açılıyor: **{$baslik}** (Kategori ID: {$kategori_id})");

    curl_setopt($ch, CURLOPT_URL, $create_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($thread_data));
    
    $response = curl_exec($ch);
    $info = curl_getinfo($ch);

    if ($info['http_code'] == 200 && strpos($info['url'], 'threads/') !== false && strpos($info['url'], 'post-thread') === false) {
         log_message("-> BAŞARILI! Konu adresi: {$info['url']}");
         return true;
    } else {
         log_message("-> HATA: Konu açma başarısız. Durum Kodu: {$info['http_code']}. Yanıt Kontrol Edilmeli (Forum mesaj sınırları/yetkiler vb.).");
         return false;
    }
}


// --- ANA İŞLEM DÖNGÜSÜ ---

$ch = oturum_ac();

if ($ch) {
    for ($i = 1; $i <= $run_count; $i++) {
        log_message("--- İlan {$i}/{$run_count} Üretim Süreci Başladı ---");

        // DURDURMA BAYRAĞI KONTROLÜ
        if (file_exists($stop_flag_file)) {
            log_message(" 🛑 DURDURMA BAYRAĞI AKTİF. Bot güvenli bir şekilde sonlandırılıyor.");
            break; 
        }

        // GPT İlan Paketi Üretimi
        $ai_cikti = openai_ile_random_ilan_uret(
            $konu_kategorisi, $openai_api_key, $model_adi_metin, $selected_platform_filter,
            $temperature, $max_tokens, $seed
        );

        if (!$ai_cikti) {
            log_message(" ⚠️ İlan Üretimi Başarısız (AI Hatası). Sonraki ilana geçiliyor.");
            continue; 
        }

        $baslik = $ai_cikti['baslik'];
        $icerik = $ai_cikti['icerik_html'];
        $etiketler = $ai_cikti['etiketler'];
        $resim_promptu = $ai_cikti['resim_promptu']; 

        log_message(" 🖼️ Üretilecek Resim Promptu: '" . substr($resim_promptu, 0, 50) . "...'");

        // RESİM ÜRETİM VE İÇERİĞE EKLEME
        $resim_url = dall_e_ile_resim_uret(
            $resim_promptu, $openai_api_key, $model_adi_gorsel, 
            $dalle_kalite, $dalle_boyut, $dalle_stil
        );

        // Resmi HTML içeriğinin başına profesyonel CSS ile ekleme
        $icerik_on = "<div style=\"text-align: center; margin-bottom: 30px; padding: 15px; background-color: #f0f3f6; border-radius: 12px; border: 1px solid #ddd; box-shadow: 0 4px 8px rgba(0,0,0,0.1);\">"
                . "<img src=\"{$resim_url}\" alt=\"{$baslik} - Kurumsal Görsel\" style=\"max-width: 100%; height: auto; border-radius: 10px; box-shadow: 0 2px 4px rgba(0,0,0,0.15); border: 3px solid #3b82f6;\"/>"
                . "</div>";

        // İmza Ekleme
        $icerik_son = "<br><hr style=\"border-top: 1px dashed #ccc;\">{$forum_signature}";

        // Konu Açma İşlemi
        konu_ac($ch, $kategori_id, $baslik, $icerik_on . $icerik . $icerik_son, $etiketler);
        
        log_message("--- İlan {$i}/{$run_count} Tamamlandı. Bir sonraki için {$delay_seconds} saniye bekleniyor. ---");
        
        if ($i < $run_count) {
             sleep($delay_seconds); 
        }
    }
    
    curl_close($ch);
    log_message("İşlem tamamlandı. Bot başarıyla sonlandı.");
} else {
    log_message(" BOT SONLANDI: Oturum açılamadığı için konu açma işlemi yapılmadı.");
}

?>