<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ultra Pro İlan Botu Admin Paneli (V9.0)</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'primary-blue': '#1e40af',
                        'primary-light': '#bfdbfe',
                        'accent-green': '#10b981',
                        'accent-red': '#ef4444',
                        'gray-dark': '#1f2937',
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f3f4f6;
        }
        .tab-button {
            transition: all 0.3s;
            padding: 12px 16px;
            border-radius: 8px 8px 0 0;
            cursor: pointer;
            font-weight: 600;
            color: #6b7280;
        }
        .tab-button.active {
            color: #1e40af;
            background-color: white;
            border-bottom: 3px solid #1e40af;
        }
        .tab-content {
            padding: 24px;
            background-color: white;
            border-radius: 0 0 12px 12px;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        label {
            display: block;
            font-weight: 500;
            margin-bottom: 0.5rem;
            color: #374151;
        }
        input[type="text"], input[type="number"], input[type="password"], textarea, select {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid #d1d5db;
            border-radius: 6px;
            transition: border-color 0.2s, box-shadow 0.2s;
        }
        input:focus, textarea:focus, select:focus {
            border-color: #1e40af;
            box-shadow: 0 0 0 1px #1e40af;
            outline: none;
        }
    </style>
</head>
<body class="min-h-screen p-4 sm:p-8 flex justify-center">

    <div class="w-full max-w-5xl bg-white shadow-2xl rounded-2xl">

        <header class="p-6 bg-gray-dark text-white rounded-t-2xl flex justify-between items-center flex-wrap gap-4">
            <h1 class="text-3xl font-extrabold">🚀 Ultra Pro Bot Yönetim Paneli</h1>
            <div id="bot-status-container" class="flex items-center space-x-3">
                <span class="text-lg font-bold">Bot Durumu:</span>
                <span id="bot-status" class="px-3 py-1 text-sm rounded-full bg-yellow-500 text-yellow-900 font-semibold">Bilinmiyor</span>
                <button type="button" id="toggle-bot-btn" class="px-4 py-2 text-sm font-bold rounded-lg transition duration-200 shadow-md">
                    Durumu Güncelle
                </button>
            </div>
        </header>

        <form id="settings-form">
            
            <div class="flex border-b border-gray-200 bg-gray-50 rounded-t-lg px-4 sm:px-6 overflow-x-auto">
                <div class="tab-button active" data-tab="forum">FORUM & Kimlik Ayarları</div>
                <div class="tab-button" data-tab="bot">Bot Kontrol & Zamanlama</div>
                <div class="tab-button" data-tab="gpt">GPT Metin Üretim Ayarları</div>
                <div class="tab-button" data-tab="dalle">DALL-E Görsel Ayarları</div>
            </div>

            <div id="tab-content-container" class="tab-content rounded-b-2xl">
                
                <div class="tab-pane active" id="forum">
                    <h3 class="text-2xl font-semibold text-primary-blue mb-6">Forum ve Hesap Bilgileri</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-4">
                        
                        <div class="form-group md:col-span-2">
                            <label for="forum_url">Forum Ana URL'si (KRİTİK - Örn: https://forum.com/)</label>
                            <input type="text" id="forum_url" name="forum_url" value="https://example.xenforo.com/" required placeholder="http://forumadresiniz.com/" />
                            <p class="text-xs text-gray-500 mt-1">Botun giriş yapacağı ve konu açacağı ana adres.</p>
                        </div>
                        
                        <div class="form-group">
                            <label for="username">Kullanıcı Adı (Giriş)</label>
                            <input type="text" id="username" name="username" value="admin_bot" required />
                        </div>

                        <div class="form-group">
                            <label for="password">Şifre (Giriş)</label>
                            <input type="password" id="password" name="password" value="1453" required />
                        </div>

                        <div class="form-group">
                            <label for="category_id">Hedef Kategori ID'si (Örn: 1068)</label>
                            <input type="number" id="category_id" name="category_id" value="1068" required min="1" />
                        </div>
                        
                        <div class="form-group">
                            <label for="target_category_name">Konu Kategorisi Adı (AI Prompt'u için)</label>
                            <input type="text" id="target_category_name" name="target_category_name" value="Dijital Hesap Alım Satım" required />
                            <p class="text-xs text-gray-500 mt-1">GPT'ye iletilecek niş kategori adıdır.</p>
                        </div>
                        
                        <div class="form-group md:col-span-2">
                            <label for="forum_signature">Konu Sonuna Eklenecek İMZA/Kapanış Metni (HTML Destekli)</label>
                            <textarea id="forum_signature" name="forum_signature" rows="4" placeholder="[B]Whatsapp İletişim:[/B] +90 5XX XXX XX XX &#10;&#10;İlanlar yapay zeka desteği ile hazırlanmıştır.">
[B]Whatsapp İletişim:[/B] +90 5XX XXX XX XX

İlanlar yapay zeka desteği ile hazırlanmıştır.
                            </textarea>
                            <p class="text-xs text-gray-500 mt-1">Botunuzun her konunun sonuna ekleyeceği metin.</p>
                        </div>
                    </div>
                </div>

                <div class="tab-pane hidden" id="bot">
                    <h3 class="text-2xl font-semibold text-primary-blue mb-6">Bot Çalıştırma ve Zamanlama Ayarları</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-4">
                        
                        <div class="form-group">
                            <label for="ilan_sayisi">Toplam İlan Sayısı (Döngü Sayısı)</label>
                            <input type="number" id="ilan_sayisi" name="ilan_sayisi" value="10" required min="1" max="50" />
                            <p class="text-xs text-gray-500 mt-1">Tek seferde kaç adet ilan açılacağını belirler.</p>
                        </div>
                        
                        <div class="form-group">
                            <label for="delay_seconds">İlanlar Arası Gecikme (Saniye)</label>
                            <input type="number" id="delay_seconds" name="delay_seconds" value="30" required min="5" max="300" />
                            <p class="text-xs text-gray-500 mt-1">Botun forum tarafından bloklanmasını engellemek için kritik.</p>
                        </div>

                        <div class="form-group">
                            <label for="platform">Platform Filtresi (Rastgele Veri Çeşitliliği)</label>
                            <select id="platform" name="platform" required>
                                <option value="Tümü (Rastgele)">Tümü (Rastgele)</option>
                                <option value="Instagram (Niş E-Ticaret)">Instagram (Niş E-Ticaret)</option>
                                <option value="TikTok (Yüksek Etkileşimli Viral)">TikTok (Yüksek Etkileşimli Viral)</option>
                                <option value="Facebook Sayfası (Kâr Garantili)">Facebook Sayfası (Kâr Garantili)</option>
                                <option value="Telegram Kanalı (Kripto/Finans)">Telegram Kanalı (Kripto/Finans)</option>
                                <option value="YouTube Kanalı (Eğitim/Tutorial)">YouTube Kanalı (Eğitim/Tutorial)</option>
                                <option value="Twitch Kanalı (Esports/Gaming)">Twitch Kanalı (Esports/Gaming)</option>
                                <option value="Discord Sunucusu (Geliştirici Topluluğu)">Discord Sunucusu (Geliştirici Topluluğu)</option>
                            </select>
                            <p class="text-xs text-gray-500 mt-1">AI'ın ilan oluşturacağı ana platformu sabitler.</p>
                        </div>
                    </div>
                    
                    <h4 class="text-xl font-semibold text-gray-700 mt-8 mb-4 border-t pt-4">Bot Bayrak Yönetimi (`bot_stop.flag`)</h4>
                    <div class="p-4 border border-yellow-300 bg-yellow-50 rounded-lg">
                        <p class="text-sm text-yellow-800">Bot, PHP tarafında bir `bot_stop.flag` dosyası var ise otomatik durur. Buradaki buton, o dosyayı oluşturmayı/silmeyi simüle eder.</p>
                        <button type="button" id="simulate-stop-flag" class="mt-3 px-6 py-2 bg-accent-red text-white font-bold rounded-lg hover:bg-red-600 transition duration-200 shadow-md">
                            Durdurma Bayrağını Oluştur / Kaldır (Simülasyon)
                        </button>
                    </div>
                </div>

                <div class="tab-pane hidden" id="gpt">
                    <h3 class="text-2xl font-semibold text-primary-blue mb-6">OpenAI GPT-4o Metin Üretim İnce Ayarları</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-4">
                        
                        <div class="form-group md:col-span-2">
                            <label for="api_key">OpenAI API Anahtarı (sk-proj-XXX)</label>
                            <input type="password" id="api_key" name="api_key" value="sk-proj-..." required placeholder="sk-proj-..." />
                            <p class="text-xs text-gray-500 mt-1">Metin ve görsel üretimi için zorunludur.</p>
                        </div>
                        
                        <div class="form-group">
                            <label for="gpt_model">GPT Metin Modeli</label>
                            <select id="gpt_model" name="gpt_model" required>
                                <option value="gpt-4o">gpt-4o (Önerilen - Hız & Kalite)</option>
                                <option value="gpt-4-turbo">gpt-4-turbo (Gelişmiş Kalite)</option>
                                <option value="gpt-3.5-turbo">gpt-3.5-turbo (Ekonomik/Hızlı)</option>
                            </select>
                            <p class="text-xs text-gray-500 mt-1">İlan metni kalitesini doğrudan etkiler.</p>
                        </div>
                        
                        <div class="form-group">
                            <label for="temperature">Yaratıcılık Derecesi (Temperature)</label>
                            <input type="number" step="0.1" id="temperature" name="temperature" value="0.8" required min="0.0" max="1.0" />
                            <p class="text-xs text-gray-500 mt-1">0.0 (Daha tutarlı) - 1.0 (Daha yaratıcı metinler).</p>
                        </div>

                        <div class="form-group">
                            <label for="max_tokens">Maksimum Token Sınırı (Metin Uzunluğu)</label>
                            <input type="number" id="max_tokens" name="max_tokens" value="3500" required min="500" max="4000" />
                            <p class="text-xs text-gray-500 mt-1">Üretilecek metnin maksimum uzunluğunu belirler.</p>
                        </div>

                        <div class="form-group">
                            <label for="seed">Sabit Tohum (Seed)</label>
                            <input type="number" id="seed" name="seed" value="42" min="1" />
                            <p class="text-xs text-gray-500 mt-1">Aynı girdilerle her zaman aynı çıktıyı almak için kullanılır.</p>
                        </div>
                    </div>
                </div>

                <div class="tab-pane hidden" id="dalle">
                    <h3 class="text-2xl font-semibold text-primary-blue mb-6">DALL-E Görsel Üretim İnce Ayarları</h3>
                    <p class="text-sm text-gray-600 mb-4">Görsel üretim modeli bot içinde sabit `dall-e-3` olarak ayarlanmıştır.</p>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-x-8 gap-y-4">
                        
                        <div class="form-group">
                            <label for="dalle_quality">Görsel Kalitesi</label>
                            <select id="dalle_quality" name="dalle_quality" required>
                                <option value="hd">HD (Yüksek Çözünürlük - Önerilen)</option>
                                <option value="standard">Standard (Hızlı)</option>
                            </select>
                            <p class="text-xs text-gray-500 mt-1">HD daha keskin ve detaylı görseller üretir.</p>
                        </div>

                        <div class="form-group">
                            <label for="dalle_size">Görsel Boyutu</label>
                            <select id="dalle_size" name="dalle_size" required>
                                <option value="1024x1024">1024x1024 (Kare)</option>
                                <option value="1792x1024">1792x1024 (Yatay - Önerilen)</option>
                                <option value="1024x1792">1024x1792 (Dikey)</option>
                            </select>
                            <p class="text-xs text-gray-500 mt-1">Yatay format, forumlar için daha uygundur.</p>
                        </div>

                        <div class="form-group">
                            <label for="dalle_style">Görsel Stili</label>
                            <select id="dalle_style" name="dalle_style" required>
                                <option value="natural">Natural (Doğal)</option>
                                <option value="vivid">Vivid (Canlı)</option>
                            </select>
                            <p class="text-xs text-gray-500 mt-1">Doğal veya daha canlı bir stil seçin.</p>
                        </div>
                    </div>
                </div>

            </div>
            
            <div class="p-6 bg-gray-50 rounded-b-2xl border-t flex justify-end">
                <button type="submit" class="px-8 py-3 bg-accent-green text-white font-bold text-lg rounded-xl shadow-lg hover:bg-green-600 transition duration-300 transform hover:scale-[1.01]">
                    Ayarları Kaydet ve bot_settings.json Çıktısı Al
                </button>
            </div>
            
        </form>
    </div>

    <div id="result-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 backdrop-blur-sm">
        <div class="bg-white rounded-xl shadow-2xl w-full max-w-2xl p-6 transform transition-all scale-100">
            <h4 class="text-xl font-bold text-accent-green mb-4 border-b pb-2">✅ Ayarlar Başarıyla Kaydedildi (JSON Çıktısı)</h4>
            <p class="text-sm text-gray-700 mb-4">Lütfen aşağıdaki JSON içeriğini kopyalayıp botun çalıştığı dizindeki **`bot_settings.json`** dosyasına kaydedin.</p>
            
            <textarea id="json-output" rows="12" class="w-full text-xs font-mono p-3 bg-gray-dark text-white rounded-lg shadow-inner resize-none"></textarea>
            
            <div class="flex justify-end space-x-3 mt-4">
                <button id="copy-json-btn" class="px-4 py-2 text-sm font-medium rounded-lg text-white bg-primary-blue hover:bg-blue-600 transition">JSON Kopyala</button>
                <button id="close-modal-btn" class="px-4 py-2 text-sm font-medium rounded-lg text-gray-700 bg-gray-100 hover:bg-gray-200 transition">Kapat</button>
            </div>
        </div>
    </div>
    
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const settingsForm = document.getElementById('settings-form');
        const tabButtons = document.querySelectorAll('.tab-button');
        const tabPanes = document.querySelectorAll('.tab-pane');
        const resultModal = document.getElementById('result-modal');
        const jsonOutput = document.getElementById('json-output');
        const closeModalBtn = document.getElementById('close-modal-btn');
        const copyJsonBtn = document.getElementById('copy-json-btn');
        const botStatusEl = document.getElementById('bot-status');
        const toggleBotBtn = document.getElementById('toggle-bot-btn');
        const simulateStopFlagBtn = document.getElementById('simulate-stop-flag');
        
        let isFlagActive = false; // Simülasyon değişkeni

        // Sekme Değiştirme Fonksiyonu
        function switchTab(targetTab) {
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabPanes.forEach(pane => pane.classList.add('hidden'));

            const activeBtn = document.querySelector(`.tab-button[data-tab="${targetTab}"]`);
            const activePane = document.getElementById(targetTab);

            if (activeBtn) activeBtn.classList.add('active');
            if (activePane) activePane.classList.remove('hidden');
        }

        // Sekme Tıklama Dinleyicileri
        tabButtons.forEach(btn => {
            btn.addEventListener('click', () => {
                switchTab(btn.getAttribute('data-tab'));
            });
        });

        // Form Gönderme İşlemi (JSON Çıktısı üretir)
        settingsForm.addEventListener('submit', (e) => {
            e.preventDefault();
            
            // Tüm ayarları topla ve botunuzun beklediği JSON yapısına dönüştür
            const settings = {
                forum_url: document.getElementById('forum_url').value,
                category_id: parseInt(document.getElementById('category_id').value),
                target_category_name: document.getElementById('target_category_name').value,
                ilan_sayisi: parseInt(document.getElementById('ilan_sayisi').value),
                api_key: document.getElementById('api_key').value,
                username: document.getElementById('username').value,
                password: document.getElementById('password').value,
                gpt_model: document.getElementById('gpt_model').value,
                dalle_quality: document.getElementById('dalle_quality').value,
                dalle_size: document.getElementById('dalle_size').value,
                dalle_style: document.getElementById('dalle_style').value,
                platform: document.getElementById('platform').value,
                delay_seconds: parseInt(document.getElementById('delay_seconds').value),
                temperature: parseFloat(document.getElementById('temperature').value),
                max_tokens: parseInt(document.getElementById('max_tokens').value),
                seed: parseInt(document.getElementById('seed').value),
                // Botunuzun signature satırında yaptığı işlemi burada simüle ediyoruz
                forum_signature: document.getElementById('forum_signature').value.trim().replace(/\n/g, '\n') 
            };
            
            const jsonString = JSON.stringify(settings, null, 4);

            jsonOutput.value = jsonString;
            resultModal.classList.remove('hidden');
            resultModal.classList.add('flex');
            
            // Gerçek entegrasyonda burada JSON verisi bir AJAX isteği ile sunucuya gönderilip 
            // 'bot_settings.json' dosyasına yazdırılmalıdır.
        });

        // Modal Kapatma
        closeModalBtn.addEventListener('click', () => {
            resultModal.classList.add('hidden');
            resultModal.classList.remove('flex');
        });

        // JSON Kopyalama
        copyJsonBtn.addEventListener('click', () => {
            jsonOutput.select();
            document.execCommand('copy');
            copyJsonBtn.textContent = 'Kopyalandı!';
            setTimeout(() => {
                copyJsonBtn.textContent = 'JSON Kopyala';
            }, 1500);
        });
        
        // ---------------------------------------------
        // Bot Bayrağı Kontrol ve Yönetim Simülasyonu
        // ---------------------------------------------

        function updateBotStatusUI(isActive) {
            isFlagActive = isActive;
            if (isActive) {
                botStatusEl.textContent = 'DURDU (Bayrak Aktif)';
                botStatusEl.className = 'px-3 py-1 text-sm rounded-full bg-accent-red text-white font-semibold';
                simulateStopFlagBtn.textContent = 'Bayrağı Kaldır (Bot Çalışsın)';
            } else {
                botStatusEl.textContent = 'ÇALIŞMAYA HAZIR';
                botStatusEl.className = 'px-3 py-1 text-sm rounded-full bg-accent-green text-white font-semibold';
                simulateStopFlagBtn.textContent = 'Durdurma Bayrağını Oluştur';
            }
        }
        
        // İlk yükleme
        updateBotStatusUI(false); 

        // Bayrak Değiştirme Simülasyonu (Gerçekte AJAX kullanılmalı)
        simulateStopFlagBtn.addEventListener('click', () => {
            updateBotStatusUI(!isFlagActive);
            // Burada PHP tarafında 'bot_stop.flag' dosyasının durumunu değiştiren AJAX isteği gönderilmelidir.
        });
        
        // Durum Güncelleme
        toggleBotBtn.addEventListener('click', () => {
            // Burada PHP tarafına 'check_flag' isteği gönderilip, isFlagActive değişkeni gerçek durumla güncellenmelidir.
            console.log("Bot Durumu Güncelleniyor...");
            updateBotStatusUI(isFlagActive); 
        });
        
        // Başlangıçta ilk sekmeyi yükle
        switchTab('forum');
    });
</script>

</body>
</html>