﻿<?php

namespace Ghf\TradeFeedback\Repository;

use XF\Mvc\Entity\Finder;
use XF\Mvc\Entity\Repository;

class Trade extends Repository
{
    public function findFeedbackForReceiver(int $receiverId): Finder
    {
        return $this->finder('Ghf\TradeFeedback:Trade')
            ->with(['Sender', 'Receiver'])
            ->where('receiver_id', $receiverId)
            ->order('trade_date', 'DESC');
    }

    public function getFeedbackCountsForUser(int $receiverId): array
    {
        $db = $this->db();
        $rows = $db->fetchAllKeyed(
            'SELECT rating, COUNT(*) AS total
             FROM xf_trade_feedback
             WHERE receiver_id = ?
             GROUP BY rating',
            'rating',
            $receiverId
        );

        return [
            'positive' => (int) ($rows['positive']['total'] ?? 0),
            'negative' => (int) ($rows['negative']['total'] ?? 0),
            'neutral' => (int) ($rows['neutral']['total'] ?? 0)
        ];
    }

    public function countFeedbackGivenBySenderToday(int $senderId, int $receiverId): int
    {
        $startOfDay = strtotime('today', \XF::$time);

        return (int) $this->db()->fetchOne(
            'SELECT COUNT(*)
             FROM xf_trade_feedback
             WHERE sender_id = ?
               AND receiver_id = ?
               AND trade_date >= ?',
            [$senderId, $receiverId, $startOfDay]
        );
    }
}
