﻿<?php

namespace Ghf\TradeFeedback\Pub\Controller;

use XF\Entity\User;
use XF\Mvc\ParameterBag;
use XF\Pub\Controller\AbstractController;

class TradeList extends AbstractController
{
    protected function preDispatchController($action, ParameterBag $params)
    {
        parent::preDispatchController($action, $params);
        $this->assertRegisteredUser();
    }

    public function actionIndex(ParameterBag $params)
    {
        $receiver = $this->assertReceiverUser();
        $visitor = \XF::visitor();

        $canView = $visitor->hasPermission('TradeFeedback', 'tradeFeedback_view')
            || $visitor->user_id === $receiver->user_id;

        if (!$canView)
        {
            throw $this->exception($this->noPermission());
        }

        $feedbacks = $this->getTradeRepo()
            ->findFeedbackForReceiver($receiver->user_id)
            ->fetch();

        $viewParams = [
            'receiver' => $receiver,
            'feedbacks' => $feedbacks
        ];

        return $this->view('Ghf\TradeFeedback:TradeList', 'ghf_trade_list', $viewParams);
    }

    protected function assertReceiverUser(): User
    {
        $receiverId = $this->filter('user_id', 'uint');
        if (!$receiverId)
        {
            throw $this->exception($this->error('User not specified.'));
        }

        /** @var User|null $receiver */
        $receiver = $this->em()->find('XF:User', $receiverId);
        if (!$receiver)
        {
            throw $this->exception($this->notFound());
        }

        if (!$receiver->hasPermission('TradeFeedback', 'tradeFeedback_receive'))
        {
            throw $this->exception($this->noPermission());
        }

        return $receiver;
    }

    /**
     * @return \Ghf\TradeFeedback\Repository\Trade
     */
    protected function getTradeRepo()
    {
        return $this->repository('Ghf\TradeFeedback:Trade');
    }
}

