﻿<?php

namespace Ghf\TradeFeedback\Extend\XF\Pub\Controller;

use XF\Mvc\ParameterBag;
use XF\Mvc\Reply\View;

class Member extends XFCP_Member
{
    public function actionMember(ParameterBag $params)
    {
        $reply = parent::actionMember($params);

        if ($reply instanceof View)
        {
            /** @var \XF\Entity\User|null $profileUser */
            $profileUser = $reply->getParam('user');
            if ($profileUser && $profileUser->hasPermission('TradeFeedback', 'tradeFeedback_receive'))
            {
                /** @var \Ghf\TradeFeedback\Repository\Trade $tradeRepo */
                $tradeRepo = $this->repository('Ghf\TradeFeedback:Trade');
                $reply->setParam('tradeFeedback', $tradeRepo->getFeedbackCountsForUser($profileUser->user_id));
            }
        }

        return $reply;
    }
}
