﻿<?php

namespace Ghf\TradeFeedback\Entity;

use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Structure;

class Trade extends Entity
{
    public static function getStructure(Structure $structure)
    {
        $structure->table = 'xf_trade_feedback';
        $structure->shortName = 'Ghf\TradeFeedback:Trade';
        $structure->primaryKey = 'trade_id';
        $structure->columns = [
            'trade_id' => ['type' => self::UINT, 'autoIncrement' => true],
            'sender_id' => ['type' => self::UINT, 'required' => true],
            'receiver_id' => ['type' => self::UINT, 'required' => true],
            'rating' => [
                'type' => self::STR,
                'required' => true,
                'allowedValues' => ['positive', 'negative', 'neutral']
            ],
            'message' => ['type' => self::STR, 'default' => '', 'maxLength' => 65535],
            'trade_date' => ['type' => self::UINT, 'default' => \XF::$time],
            'ip_address' => ['type' => self::BINARY, 'maxLength' => 16, 'nullable' => true]
        ];

        $structure->relations = [
            'Sender' => [
                'entity' => 'XF:User',
                'type' => self::TO_ONE,
                'conditions' => 'sender_id',
                'primary' => true
            ],
            'Receiver' => [
                'entity' => 'XF:User',
                'type' => self::TO_ONE,
                'conditions' => 'receiver_id',
                'primary' => true
            ]
        ];

        return $structure;
    }
}
