<?php

namespace AutoForumSyncPro\Admin\Controller;

use XF\Admin\Controller\AbstractController;
use XF\Mvc\ParameterBag;

class Logs extends AbstractController
{
    /**
     * Log kayıtları
     */
    public function actionIndex()
    {
        $page = $this->filterPage();
        $perPage = 50;

        $logger = new \AutoForumSyncPro\Service\Logger();
        $logs = $logger->getRecentLogs($perPage * $page);
        
        $totalLogs = \XF::db()->fetchOne("SELECT COUNT(*) FROM xf_auto_forum_sync_logs");

        $viewParams = array(
            'logs' => $logs,
            'totalLogs' => $totalLogs,
            'page' => $page,
            'perPage' => $perPage
        );

        return $this->view('AutoForumSyncPro:Logs', 'auto_forum_sync_logs', $viewParams);
    }

    /**
     * Hata logları
     */
    public function actionErrors()
    {
        $logger = new \AutoForumSyncPro\Service\Logger();
        $errorLogs = $logger->getErrorLogs(100);
        
        $viewParams = array(
            'logs' => $errorLogs
        );

        return $this->view('AutoForumSyncPro:Logs', 'auto_forum_sync_error_logs', $viewParams);
    }

    /**
     * Log istatistikleri
     */
    public function actionStats()
    {
        $logger = new \AutoForumSyncPro\Service\Logger();
        $stats = $logger->getLogStats();
        
        $viewParams = array(
            'stats' => $stats
        );

        return $this->view('AutoForumSyncPro:Logs', 'auto_forum_sync_log_stats', $viewParams);
    }

    /**
     * Logları temizle
     */
    public function actionClean()
    {
        $this->assertPostOnly();

        $days = $this->filter('days', 'uint');
        if ($days < 1) {
            $days = 30;
        }

        $logger = new \AutoForumSyncPro\Service\Logger();
        $logger->cleanLogs($days);

        return $this->message('Loglar temizlendi.');
    }

    /**
     * Log detayı
     */
    public function actionView(ParameterBag $params)
    {
        $log = \XF::db()->fetchRow("SELECT * FROM xf_auto_forum_sync_logs WHERE log_id = ?", $params->log_id);
        
        if (!$log) {
            throw $this->exception($this->notFound('Log bulunamadı.'));
        }

        $viewParams = array(
            'log' => $log
        );

        return $this->view('AutoForumSyncPro:Logs', 'auto_forum_sync_log_view', $viewParams);
    }
}
