# AutoForumSync Pro - Kurulum Kılavuzu

## 📋 Sistem Gereksinimleri

### Minimum Gereksinimler
- **XenForo**: 2.2.0 veya üzeri
- **PHP**: 8.1.0 veya üzeri
- **MySQL**: 5.7 veya üzeri / MariaDB 10.2 veya üzeri
- **Bellek**: En az 256MB RAM
- **Disk**: En az 100MB boş alan

### Önerilen Gereksinimler
- **PHP**: 8.2.0 veya üzeri
- **Bellek**: 512MB RAM veya üzeri
- **Disk**: 500MB boş alan
- **SSD**: Daha hızlı I/O için

## 🔧 Adım Adım Kurulum

### 1. Dosyaları İndir ve Çıkar

```bash
# Eklenti dosyalarını indirin
wget https://github.com/your-repo/AutoForumSyncPro.zip

# Arşivi çıkarın
unzip AutoForumSyncPro.zip

# XenForo root dizinine kopyalayın
cp -r AutoForumSyncPro /path/to/xenforo/src/addons/
```

### 2. Composer Bağımlılıklarını Yükle

```bash
cd /path/to/xenforo

# Composer bağımlılıklarını yükle
composer require guzzlehttp/guzzle:^7.0
composer require symfony/dom-crawler:^5.0
composer require symfony/css-selector:^5.0
```

### 3. Veritabanı Tablolarını Oluştur

#### MySQL/MariaDB için:

```sql
-- Hedef siteler tablosu
CREATE TABLE `xf_auto_forum_sync_targets` (
  `target_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_name` varchar(255) NOT NULL,
  `base_url` varchar(500) NOT NULL,
  `site_type` enum('xenforo','vbulletin','phpbb','custom') NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `default_user_id` int(10) unsigned NOT NULL,
  `default_forum_id` int(10) unsigned NOT NULL,
  `delay_between_requests` int(10) unsigned NOT NULL DEFAULT '1',
  `last_run_time` int(10) unsigned DEFAULT NULL,
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`target_id`),
  KEY `enabled` (`enabled`),
  KEY `site_type` (`site_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- İçerik logları tablosu
CREATE TABLE `xf_auto_forum_sync_content` (
  `content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` varchar(255) NOT NULL,
  `source_url` varchar(500) NOT NULL,
  `thread_id` int(10) unsigned DEFAULT NULL,
  `post_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `status` enum('published','pending','failed') NOT NULL DEFAULT 'published',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`content_id`),
  UNIQUE KEY `unique_id` (`unique_id`),
  KEY `status` (`status`),
  KEY `user_id` (`user_id`),
  KEY `created_date` (`created_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Spam filtreleri tablosu
CREATE TABLE `xf_auto_forum_sync_blacklist` (
  `blacklist_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `word` varchar(255) NOT NULL,
  `type` enum('word','regex') NOT NULL DEFAULT 'word',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`blacklist_id`),
  KEY `enabled` (`enabled`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Beyaz liste tablosu
CREATE TABLE `xf_auto_forum_sync_whitelist` (
  `whitelist_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `word` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`whitelist_id`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Anahtar kelime değiştirme tablosu
CREATE TABLE `xf_auto_forum_sync_replacements` (
  `replacement_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `search_text` varchar(500) NOT NULL,
  `replace_text` varchar(500) NOT NULL,
  `type` enum('simple','regex','url') NOT NULL DEFAULT 'simple',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`replacement_id`),
  KEY `enabled` (`enabled`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- HTML filtreleri tablosu
CREATE TABLE `xf_auto_forum_sync_html_filters` (
  `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `element` varchar(100) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Bekleyen içerikler tablosu
CREATE TABLE `xf_auto_forum_sync_pending` (
  `pending_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` varchar(255) NOT NULL,
  `source_url` varchar(500) NOT NULL,
  `title` varchar(500) NOT NULL,
  `content` longtext NOT NULL,
  `tags` text,
  `user_id` int(10) unsigned NOT NULL,
  `forum_id` int(10) unsigned NOT NULL,
  `status` enum('pending_approval','approved','rejected') NOT NULL DEFAULT 'pending_approval',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`pending_id`),
  UNIQUE KEY `unique_id` (`unique_id`),
  KEY `status` (`status`),
  KEY `user_id` (`user_id`),
  KEY `forum_id` (`forum_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Zamanlanmış çalışmalar tablosu
CREATE TABLE `xf_auto_forum_sync_schedules` (
  `schedule_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `target_id` int(10) unsigned NOT NULL,
  `interval_minutes` int(10) unsigned NOT NULL,
  `next_run` int(10) unsigned NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`schedule_id`),
  KEY `target_id` (`target_id`),
  KEY `next_run` (`next_run`),
  KEY `enabled` (`enabled`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Log tablosu
CREATE TABLE `xf_auto_forum_sync_logs` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` varchar(50) NOT NULL,
  `level` enum('debug','info','warning','error') NOT NULL,
  `message` text NOT NULL,
  `context` text,
  `created_date` int(10) unsigned NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`),
  KEY `created_date` (`created_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
```

### 4. Varsayılan Verileri Ekle

```sql
-- Varsayılan spam filtreleri
INSERT INTO `xf_auto_forum_sync_blacklist` (`word`, `type`, `enabled`, `created_date`) VALUES
('viagra', 'word', 1, UNIX_TIMESTAMP()),
('casino', 'word', 1, UNIX_TIMESTAMP()),
('porn', 'word', 1, UNIX_TIMESTAMP()),
('spam', 'word', 1, UNIX_TIMESTAMP()),
('pills', 'word', 1, UNIX_TIMESTAMP()),
('/\b(viagra|casino|porn)\b/i', 'regex', 1, UNIX_TIMESTAMP());

-- Varsayılan HTML filtreleri
INSERT INTO `xf_auto_forum_sync_html_filters` (`element`, `enabled`, `created_date`) VALUES
('script', 1, UNIX_TIMESTAMP()),
('style', 1, UNIX_TIMESTAMP()),
('iframe', 1, UNIX_TIMESTAMP()),
('object', 1, UNIX_TIMESTAMP()),
('embed', 1, UNIX_TIMESTAMP());

-- Varsayılan anahtar kelime değiştirmeleri
INSERT INTO `xf_auto_forum_sync_replacements` (`search_text`, `replace_text`, `type`, `enabled`, `created_date`) VALUES
('eski-site.com', 'yeni-site.com', 'url', 1, UNIX_TIMESTAMP()),
('Eski Site', 'Yeni Site', 'simple', 1, UNIX_TIMESTAMP());
```

### 5. XenForo Admin Panelinden Eklentiyi Etkinleştir

1. **Admin Panel**'e giriş yapın
2. **Eklentiler** → **Eklenti Yükle**'ye gidin
3. **Dosya Seç** butonuna tıklayın
4. `install/addon-AutoForumSyncPro.xml` dosyasını seçin
5. **Eklenti Yükle** butonuna tıklayın
6. Eklentiyi **Etkinleştir**

### 6. İzinleri Ayarla

1. **Admin Panel** → **Kullanıcılar** → **Yönetici İzinleri**
2. **AutoForumSync Pro** izinlerini ayarlayın
3. Gerekli kullanıcılara **Yönet** izni verin

### 7. Cron Job Ayarları

#### Otomatik Cron (Önerilen)
XenForo otomatik olarak cron job'ları çalıştırır. Ek ayar gerekmez.

#### Manuel Cron
Eğer otomatik cron çalışmıyorsa:

```bash
# Crontab'a ekleyin
*/15 * * * * /usr/bin/php /path/to/xenforo/cmd.php xf:run-cron
```

### 8. İlk Yapılandırma

1. **Admin Panel** → **Eklentiler** → **AutoForumSync Pro** → **Ayarlar**
2. Temel ayarları yapılandırın:
   - Eklentiyi etkinleştirin
   - Varsayılan kullanıcı seçin
   - Varsayılan forum seçin
   - Maksimum post sayısını ayarlayın
   - Gecikme süresini ayarlayın

3. **Hedef Siteler** → **Yeni Hedef Site**
4. İlk hedef sitenizi ekleyin

## 🔍 Kurulum Sonrası Kontroller

### 1. Dosya İzinleri

```bash
# Log dizini izinleri
chmod 755 /path/to/xenforo/internal_data/
chmod 644 /path/to/xenforo/internal_data/auto_forum_sync.log

# Eklenti dosya izinleri
chmod -R 644 /path/to/xenforo/src/addons/AutoForumSyncPro/
```

### 2. PHP Ayarları

```ini
; php.ini dosyasında kontrol edin
memory_limit = 256M
max_execution_time = 300
allow_url_fopen = On
curl.cainfo = /path/to/cacert.pem
```

### 3. Test Bağlantısı

```php
// Test scripti
<?php
require_once '/path/to/xenforo/src/XF.php';
XF::start('/path/to/xenforo');

$fetcher = new \AutoForumSyncPro\Service\ContentFetcher();
$result = $fetcher->testConnection('https://httpbin.org/status/200');

if ($result) {
    echo "Bağlantı testi başarılı!";
} else {
    echo "Bağlantı testi başarısız!";
}
?>
```

### 3. Log Kontrolü

```bash
# Log dosyasını kontrol edin
tail -f /path/to/xenforo/internal_data/auto_forum_sync.log

# Veritabanı loglarını kontrol edin
SELECT * FROM xf_auto_forum_sync_logs ORDER BY created_date DESC LIMIT 10;
```

## 🚨 Sorun Giderme

### Yaygın Kurulum Sorunları

#### 1. Composer Hatası
```bash
# Composer'ı güncelleyin
composer self-update
composer install --no-dev --optimize-autoloader
```

#### 2. Veritabanı Hatası
```sql
-- Tablo var mı kontrol edin
SHOW TABLES LIKE 'xf_auto_forum_sync_%';

-- Eksik tabloları oluşturun
-- (Yukarıdaki SQL komutlarını tekrar çalıştırın)
```

#### 3. İzin Hatası
```bash
# Dosya sahipliğini düzeltin
chown -R www-data:www-data /path/to/xenforo/src/addons/AutoForumSyncPro/
chmod -R 755 /path/to/xenforo/src/addons/AutoForumSyncPro/
```

#### 4. Memory Limit Hatası
```ini
; php.ini dosyasında
memory_limit = 512M
max_execution_time = 600
```

### Debug Modu

```php
// Debug modunu etkinleştirin
$logger = new \AutoForumSyncPro\Service\Logger();
$logger->setLogLevel('debug');
```

## 📞 Destek

Kurulum sırasında sorun yaşarsanız:

1. **Log dosyalarını kontrol edin**
2. **XenForo error log'larını kontrol edin**
3. **GitHub Issues**'da sorun bildirin
4. **Topluluk forumlarında** yardım isteyin

---

**Not**: Bu kurulum kılavuzu XenForo 2.2.0+ için hazırlanmıştır. Eski sürümler için ek ayarlar gerekebilir.
