<?php

namespace XenSoluce\SEOOptimization\XFRM\Entity;

use XF\Mvc\Entity\Structure;
use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Manager;

class ResourceItem extends XFCP_ResourceItem
{
    protected function _preSave()
    {
        parent::_preSave();

        if($this->isChanged('prefix_id') && $this->prefix_id)
        {
            $prefix = $this->Prefix;

            if($prefix->xs_seo_meta_robots)
            {
                $seo = $this->xs_seo;
                $seo['meta_robots'] = $prefix->xs_seo_meta_robots;
                $this->xs_seo = $seo;
            }
        }
    }

    public function getSeoTitleIsNull()
    {
        return $this->_values['xs_seo_title'] == '';
    }

    public function getXsSeoTitle()
    {
        if(
            isset($this->xs_seo['save_url'])
            && isset($this->_values['xs_seo_title'])
            && $this->_values['xs_seo_title'] !== ''
            && $this->_values['xs_seo_title'] !== null
        ) {
            return $this->_values['xs_seo_title'];
        }

        return $this->title;
    }

    public static function getStructure(Structure $structure)
    {
        $structure = parent::getStructure($structure);
        $structure->getters['xs_seo_title'] = true;
        return $structure;
    }
}