<?php

namespace XenSoluce\SEOOptimization\XFMG\Entity;

use XF\Mvc\Entity\Structure;
use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Manager;

class Album extends XFCP_Album
{
    public function getSeoTitleIsNull()
    {
        return $this->_values['xs_seo_title'] == '';
    }

    public function getXsSeoTitle()
    {
        if(
            isset($this->xs_seo['save_url'])
            && isset($this->_values['xs_seo_title'])
            && $this->_values['xs_seo_title'] !== ''
            && $this->_values['xs_seo_title'] !== null
        ) {
            return $this->_values['xs_seo_title'];
        }

        return $this->title;
    }

    public static function getStructure(Structure $structure)
    {
        $structure = parent::getStructure($structure);
        $structure->getters['xs_seo_title'] = true;
        return $structure;
    }
}